/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.impl.SqlMappingItem;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlProcessorLexer;
import org.sqlproc.engine.impl.SqlProcessorParser;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlMappingRule {
    protected static Logger logger = LoggerFactory.getLogger(SqlMappingRule.class);
    String raw;
    private Map<String, SqlMappingItem> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlMappingRule getInstance(String name, String mappingStatement, SqlTypeFactory typeFactory) throws SqlEngineException {
        SqlMappingRule sqlMappingRule;
        if (logger.isDebugEnabled()) {
            logger.debug(">> getInstance, mappingStatement=" + mappingStatement);
        }
        SqlMappingRule mapping = null;
        try {
            StringBuilder sbMappingStatement = new StringBuilder(mappingStatement);
            SqlProcessorLexer lexer = new SqlProcessorLexer((CharStream)new ANTLRStringStream(sbMappingStatement.toString()));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlProcessorParser parser = new SqlProcessorParser((TokenStream)tokens);
            try {
                mapping = parser.mapping(name, typeFactory, false);
            }
            catch (RecognitionException ex) {
                ex.printStackTrace();
            }
            if (!lexer.getErrors().isEmpty() || !parser.getErrors().isEmpty()) {
                throw new SqlEngineException("Mapping error for '" + mappingStatement + "'", lexer.getErrors(), parser.getErrors());
            }
            sqlMappingRule = mapping;
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("<< getInstance, mapping=" + mapping);
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<< getInstance, mapping=" + mapping);
        }
        return sqlMappingRule;
    }

    public SqlMappingRule() {
        this.mappings = new LinkedHashMap<String, SqlMappingItem>();
    }

    public SqlMappingRule(String raw) {
        this.raw = raw;
    }

    public String getRaw() {
        return this.raw;
    }

    void addMapping(SqlMappingItem item) {
        this.mappings.put(item.getDbName(), item);
    }

    Map<String, SqlMappingItem> getMappings() {
        return this.mappings;
    }

    public static SqlMappingResult merge(SqlMappingRule mapping, SqlProcessResult processResult) {
        return new SqlMappingResult(processResult.getCtx(), mapping, processResult.getOutputValues());
    }
}

