/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlMetaIfItem;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlUtils;

class SqlMetaSqlFragment
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final Pattern patternWhere = Pattern.compile("\\s*(and|AND|or|OR)?\\s*(.*)\\s*");
    static final Pattern patternValues = Pattern.compile("\\s*\\(?\\s*,?\\s*(.*?)\\s*,?\\s*\\)?\\s*");
    static final Pattern patternSet = Pattern.compile("\\s*,?\\s*(.*?)\\s*,?\\s*");
    static final Pattern patternColumns = Pattern.compile("\\s*\\(?\\s*,?\\s*(.*?)\\s*,?\\s*\\)?\\s*");
    List<SqlMetaIfItem> elements = new ArrayList<SqlMetaIfItem>();
    Type type = null;
    boolean optimistic;

    SqlMetaSqlFragment(Type type) {
        this.type = type;
    }

    SqlMetaSqlFragment(String type) {
        this(Type.valueOf(SqlUtils.beforeChar(type, '=').toUpperCase()));
        String s = SqlUtils.afterChar(type, '=');
        if (s != null && s.equalsIgnoreCase("opt")) {
            this.optimistic = true;
        }
    }

    void addElement(SqlMetaIfItem element) {
        this.elements.add(element);
    }

    void handleSqlFragment(StringBuilder s, SqlProcessContext ctx) {
        if (this.type == Type.WHERE) {
            Matcher matcher = patternWhere.matcher(s);
            if (!matcher.matches()) {
                return;
            }
            String rest = matcher.group(2);
            s.delete(0, s.length());
            s.append("WHERE ").append(rest);
        } else if (this.type == Type.SET && ctx.getSqlStatementType() == SqlMetaStatement.Type.UPDATE) {
            Matcher matcher = patternSet.matcher(s);
            String fragment = matcher.matches() ? matcher.group(1) : s.toString();
            s.delete(0, s.length());
            s.append("SET ").append(fragment);
        } else if (this.type == Type.VALUES && ctx.getSqlStatementType() == SqlMetaStatement.Type.CREATE) {
            Matcher matcher = patternValues.matcher(s);
            String fragment = matcher.matches() ? matcher.group(1) : s.toString();
            s.delete(0, s.length());
            s.append("VALUES").append("(").append(fragment).append(")");
        } else if (this.type == Type.COLUMNS && ctx.getSqlStatementType() == SqlMetaStatement.Type.CREATE) {
            Matcher matcher = patternColumns.matcher(s);
            String fragment = matcher.matches() ? matcher.group(1) : s.toString();
            s.delete(0, s.length());
            s.append("(").append(fragment).append(")");
        }
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult(ctx);
        result.setSql(new StringBuilder());
        ctx.setSqlFragmentType(this.type);
        for (SqlMetaIfItem item : this.elements) {
            SqlProcessResult itemResult = item.process(ctx);
            if (!itemResult.isAdd()) continue;
            result.getSql().append((CharSequence)itemResult.getSql());
            result.addInputValues(itemResult.getInputValues());
            result.addMappedInputValues(itemResult.getMappedInputValues());
            result.addOutputValues(itemResult.getOutputValues());
            result.addIdentities(itemResult.getIdentities());
            result.addOutValues(itemResult.getOutValues());
            result.addTrue();
        }
        if (result.isAdd()) {
            this.handleSqlFragment(result.getSql(), ctx);
        }
        ctx.setSqlFragmentType(null);
        return result;
    }

    static enum Type {
        WHERE,
        SET,
        VALUES,
        COLUMNS;

    }
}

