/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.type.OutValueSetter;
import org.sqlproc.engine.type.SqlDefaultType;

public abstract class SqlEnumStringType
extends SqlDefaultType {
    @Override
    public Class<?>[] getClassTypesForDefault() {
        return new Class[0];
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"ENUMSTRING", "ESTRING"};
    }

    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Class<?> attributeType;
        Object enumInstance;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult for META type " + this + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue + ", resultType" + (resultValue != null ? resultValue.getClass() : null));
        }
        if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, enumInstance = runtimeCtx.getValueToEnum(attributeType = runtimeCtx.getAttributeType(resultInstance.getClass(), attributeName), resultValue), attributeType)) {
            return;
        }
        this.error(ingoreError, "There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, boolean ingoreError, Class<?> ... inputTypes) throws SqlRuntimeException {
        Object o;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter for META type " + this + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputTypes=" + inputTypes);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
            return;
        }
        if (!inputValue.getClass().isEnum()) {
            if (!(inputValue instanceof Collection)) {
                if (inputValue instanceof OutValueSetter) {
                    query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
                    return;
                }
                this.error(ingoreError, "Incorrect string based enum " + inputValue + " for " + paramName);
                return;
            }
        } else {
            Object o2 = runtimeCtx.getEnumToValue(inputValue);
            if (o2 != null && o2 instanceof String) {
                query.setParameter(paramName, (String)o2, this.getProviderSqlType(), new Class[0]);
                return;
            }
            this.error(ingoreError, "ENUM_STRING parameter " + paramName + " " + inputValue + " " + inputValue.getClass() + " " + o2);
            return;
        }
        ArrayList<String> vals = new ArrayList<String>();
        Iterator iter = ((Collection)inputValue).iterator();
        while (true) {
            if (!iter.hasNext()) {
                query.setParameterList(paramName, vals.toArray());
                return;
            }
            Object val = iter.next();
            if (!val.getClass().isEnum()) {
                this.error(ingoreError, "Incorrect string based enum item " + val + " for " + paramName);
                return;
            }
            o = runtimeCtx.getEnumToValue(val);
            if (o == null || !(o instanceof String)) break;
            vals.add((String)o);
        }
        this.error(ingoreError, "Incorrect string based enum item value " + o + " for " + paramName);
    }
}

