/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlBlobType;

public class JdbcBlobType
extends SqlBlobType
implements JdbcSqlType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{Blob.class};
    }

    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return 2004;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        Blob value = Character.isDigit(columnLabel.charAt(0)) ? rs.getBlob(Integer.parseInt(columnLabel)) : rs.getBlob(columnLabel);
        return value;
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        Blob blob = (Blob)value;
        st.setBlob(index, blob);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        Blob result = cs.getBlob(index);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

