/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlLongType;

public class JdbcLongType
extends SqlLongType
implements JdbcSqlType {
    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return -5;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return new Long(rs.getLong(Integer.parseInt(columnLabel)));
        }
        return new Long(rs.getLong(columnLabel));
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        st.setLong(index, (Long)value);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        Long result = new Long(cs.getLong(index));
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

