/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.type.SqlMetaType;
import org.sqlproc.engine.type.SqlTaggedMetaType;
import org.sqlproc.engine.type.SqlTypeFactory;

public abstract class SqlDefaultType
implements SqlTaggedMetaType {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Class<?>[] getClassTypesForDefault() {
        return this.getClassTypes();
    }

    @Override
    public void addScalar(SqlTypeFactory typeFactory, SqlQuery query, String dbName, Class<?> ... attributeTypes) {
        this.addScalarEntryLog(this.logger, this, typeFactory, query, dbName, attributeTypes);
        if (this.getProviderSqlType() != null) {
            query.addScalar(dbName, this.getProviderSqlType(), new Class[0]);
        } else {
            SqlMetaType type;
            SqlMetaType sqlMetaType = type = attributeTypes.length > 0 ? typeFactory.getMetaType(attributeTypes[0]) : null;
            if (type != null) {
                query.addScalar(dbName, type, new Class[0]);
            } else {
                query.addScalar(dbName);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        SqlMetaType type;
        this.setResultEntryLog(this.logger, this, runtimeCtx, resultInstance, attributeName, resultValue, ingoreError);
        if (this.getClassTypesForDefault() != null && this.getClassTypesForDefault().length > 0) {
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, resultValue, this.getClassTypesForDefault())) {
                return;
            }
            this.error(this.logger, ingoreError, "There's no default setter for '" + attributeName + "' in " + resultInstance + ", META type is " + this);
            return;
        }
        Class<?> attributeType = runtimeCtx.getAttributeType(resultInstance.getClass(), attributeName);
        if (attributeType == null) {
            this.error(this.logger, ingoreError, "There's problem with attribute type for '" + attributeName + "' in " + resultInstance + ", META type is " + this);
            return;
        }
        if (resultValue != null && resultValue instanceof BigDecimal && attributeType != BigDecimal.class) {
            resultValue = ((BigDecimal)resultValue).intValue();
        } else if (resultValue != null && resultValue instanceof BigInteger && attributeType != BigInteger.class) {
            resultValue = ((BigInteger)resultValue).intValue();
        }
        if (attributeType.isEnum()) {
            Class<?> enumType = runtimeCtx.getEnumToClass(attributeType);
            if (enumType == Integer.class || enumType == Integer.TYPE) {
                runtimeCtx.getTypeFactory().getEnumIntegerType().setResult(runtimeCtx, resultInstance, attributeName, resultValue, ingoreError);
                return;
            }
            if (enumType == String.class) {
                runtimeCtx.getTypeFactory().getEnumStringType().setResult(runtimeCtx, resultInstance, attributeName, resultValue, ingoreError);
                return;
            }
            this.error(this.logger, ingoreError, "There's no enum setter for '" + attributeName + "' in " + resultInstance + ", META type is " + this);
            return;
        }
        if (this.getProviderSqlType() == null && (type = runtimeCtx.getTypeFactory().getMetaType(attributeType)) != null) {
            type.setResult(runtimeCtx, resultInstance, attributeName, resultValue, ingoreError);
            return;
        }
        if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, resultValue, attributeType)) {
            return;
        }
        this.error(this.logger, ingoreError, "There's no setter for '" + attributeName + "' in " + resultInstance + ", META type is " + this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, boolean ingoreError, Class<?> ... inputTypes) throws SqlRuntimeException {
        this.setParameterEntryLog(this.logger, this, runtimeCtx, query, paramName, inputValue, ingoreError, inputTypes);
        if (this.getProviderSqlType() != null) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
                return;
            }
            if (inputValue instanceof Collection) {
                query.setParameterList(paramName, ((Collection)inputValue).toArray(), this.getProviderSqlType(), new Class[0]);
                return;
            }
            query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
            return;
        }
        if (!(inputValue instanceof Collection)) {
            if (inputTypes[0].isEnum()) {
                Class<?> clazz = runtimeCtx.getEnumToClass(inputTypes[0]);
                if (clazz == String.class) {
                    runtimeCtx.getTypeFactory().getEnumStringType().setParameter(runtimeCtx, query, paramName, inputValue, ingoreError, inputTypes);
                    return;
                }
                if (clazz == Integer.class) {
                    runtimeCtx.getTypeFactory().getEnumIntegerType().setParameter(runtimeCtx, query, paramName, inputValue, ingoreError, inputTypes);
                    return;
                }
                this.error(this.logger, ingoreError, "Incorrect enum type " + inputValue + " for " + paramName + ", META type is DEFAULT" + this);
                return;
            }
            SqlMetaType type = runtimeCtx.getTypeFactory().getMetaType(inputTypes[0]);
            if (type != null) {
                type.setParameter(runtimeCtx, query, paramName, inputValue, ingoreError, inputTypes);
                return;
            }
            this.error(this.logger, ingoreError, "Incorrect default type " + inputValue + " for " + paramName + ", META type is DEFAULT" + this);
            return;
        }
        ArrayList<Object> vals = new ArrayList<Object>();
        boolean isEnum = false;
        for (Object val : (Collection)inputValue) {
            if (!val.getClass().isEnum()) break;
            isEnum = true;
            Object o = runtimeCtx.getEnumToValue(val);
            if (o == null) {
                this.error(this.logger, ingoreError, "Incorrect enum type item value " + o + " for " + paramName + ", META type is DEFAULT" + this);
                return;
            }
            vals.add(o);
        }
        if (isEnum) {
            query.setParameterList(paramName, vals.toArray());
            return;
        }
        query.setParameterList(paramName, ((Collection)inputValue).toArray());
    }
}

