/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2ProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.datadoghq.datadog_lambda_java.ColdStart;
import com.datadoghq.datadog_lambda_java.CustomMetric;
import com.datadoghq.datadog_lambda_java.DDLogger;
import com.datadoghq.datadog_lambda_java.EnhancedMetric;
import com.datadoghq.datadog_lambda_java.Headerable;
import com.datadoghq.datadog_lambda_java.SQSHeaderable;
import com.datadoghq.datadog_lambda_java.Tracing;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Request;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.MDC;

public class DDLambda {
    private String ENHANCED_ENV = "DD_ENHANCED_METRICS";
    private String ENHANCED_PREFIX = "aws.lambda.enhanced.";
    private String INVOCATION = "invocations";
    private String ERROR = "errors";
    private String MDC_TRACE_CONTEXT_FIELD = "dd.trace_context";
    private String JSON_TRACE_ID = "dd.trace_id";
    private String JSON_SPAN_ID = "dd.span_id";
    private String TRACE_ENABLED_ENV = "DD_TRACE_ENABLED";
    private Tracing tracing;
    private boolean enhanced = true;
    private Scope tracingScope;

    public DDLambda(Context cxt) {
        this.tracing = new Tracing();
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
        this.addTraceContextToMDC();
        this.startSpan(new HashMap<String, String>(), cxt);
    }

    protected DDLambda(Context cxt, String xrayTraceInfo) {
        this.tracing = new Tracing(xrayTraceInfo);
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
        this.addTraceContextToMDC();
        this.startSpan(new HashMap<String, String>(), cxt);
    }

    public DDLambda(APIGatewayProxyRequestEvent req, Context cxt) {
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
        this.tracing = new Tracing(req);
        this.tracing.submitSegment();
        this.addTraceContextToMDC();
        this.startSpan(req.getHeaders(), cxt);
    }

    public DDLambda(APIGatewayV2ProxyRequestEvent req, Context cxt) {
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
        this.tracing = new Tracing(req);
        this.tracing.submitSegment();
        this.addTraceContextToMDC();
        this.startSpan(req.getHeaders(), cxt);
    }

    public DDLambda(SQSEvent event, Context cxt) {
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
        SQSHeaderable headerable = new SQSHeaderable(event);
        this.tracing = new Tracing(headerable);
        this.tracing.submitSegment();
        this.addTraceContextToMDC();
        this.startSpan(headerable.getHeaders(), cxt);
    }

    public DDLambda(Headerable req, Context cxt) {
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
        this.tracing = new Tracing(req);
        this.tracing.submitSegment();
        this.addTraceContextToMDC();
        this.startSpan(req.getHeaders(), cxt);
    }

    private void startSpan(Map<String, String> headers, Context cxt) {
        if (!this.checkTraceEnabled()) {
            return;
        }
        String functionName = "";
        if (cxt != null) {
            functionName = cxt.getFunctionName();
        }
        if (headers == null) {
            DDLogger.getLoggerImpl().error("The request passed to DDLambda contained null headers. Are you sure the handler signature matches the event provided?", new Object[0]);
            headers = new HashMap<String, String>();
        }
        Tracer tracer = GlobalTracer.get();
        SpanContext parentContext = tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(headers));
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan("aws.lambda").asChildOf(parentContext);
        spanBuilder = this.addDDTags(spanBuilder, cxt);
        Span thisSpan = spanBuilder.start();
        this.tracingScope = tracer.activateSpan(thisSpan);
    }

    public void finish() {
        Span span = GlobalTracer.get().activeSpan();
        if (this.tracingScope == null) {
            DDLogger.getLoggerImpl().debug("Unable to close tracing scope because it is null.", new Object[0]);
            return;
        }
        this.tracingScope.close();
        if (span == null) {
            DDLogger.getLoggerImpl().debug("Unable to finish span because it is null.", new Object[0]);
            return;
        }
        span.finish();
    }

    private Tracer.SpanBuilder addDDTags(Tracer.SpanBuilder spanBuilder, Context cxt) {
        String requestId = "";
        String functionName = "";
        String functionArn = "";
        String functionVersion = "";
        if (cxt == null) {
            return spanBuilder;
        }
        requestId = cxt.getAwsRequestId();
        functionName = cxt.getFunctionName();
        functionArn = this.santitizeFunctionArn(cxt.getInvokedFunctionArn());
        functionVersion = cxt.getFunctionVersion();
        if (spanBuilder != null) {
            spanBuilder.withTag("request_id", requestId);
            spanBuilder.withTag("service", "aws.lambda");
            spanBuilder.withTag("function_arn", functionArn.toLowerCase());
            spanBuilder.withTag("cold_start", ColdStart.getColdStart(cxt));
            spanBuilder.withTag("datadog_lambda", "0.3.0");
            spanBuilder.withTag("resource_names", functionName);
            spanBuilder.withTag("function_version", functionVersion);
            spanBuilder.withTag("resource.name", functionName);
        }
        return spanBuilder;
    }

    protected String santitizeFunctionArn(String functionArn) {
        String[] arnParts = functionArn.split(":");
        if (arnParts.length > 7) {
            functionArn = String.join((CharSequence)":", Arrays.copyOfRange(arnParts, 0, 7));
        }
        return functionArn;
    }

    private void addTraceContextToMDC() {
        Map<String, String> traceContext = this.getTraceContext();
        if (traceContext == null) {
            return;
        }
        String traceId = traceContext.get(this.tracing.TRACE_ID_KEY);
        String spanId = traceContext.get(this.tracing.SPAN_ID_KEY);
        if (traceId == null || spanId == null) {
            return;
        }
        MDC.put((String)this.JSON_TRACE_ID, (String)traceId);
        MDC.put((String)this.JSON_SPAN_ID, (String)spanId);
        MDC.put((String)this.MDC_TRACE_CONTEXT_FIELD, (String)this.getTraceContextString());
    }

    protected boolean checkEnhanced() {
        String sysEnhanced = System.getenv(this.ENHANCED_ENV);
        if (sysEnhanced == null) {
            return true;
        }
        return !sysEnhanced.toLowerCase().equals("false");
    }

    protected boolean checkTraceEnabled() {
        String sysTraceEnabled = System.getenv(this.TRACE_ENABLED_ENV);
        if (sysTraceEnabled == null) {
            return false;
        }
        return sysTraceEnabled.toLowerCase().equals("true");
    }

    public void metric(String name, double value, Map<String, Object> tags) {
        new CustomMetric(name, value, tags).write();
    }

    public void metric(String name, double value, Map<String, Object> tags, Date date) {
        new CustomMetric(name, value, tags, date).write();
    }

    public void error(Context cxt) {
        this.recordEnhanced(this.ERROR, cxt);
    }

    private void recordEnhanced(String basename, Context cxt) {
        String metricName = basename;
        Map<String, Object> tags = null;
        if (this.enhanced) {
            metricName = this.ENHANCED_PREFIX + basename;
            tags = EnhancedMetric.makeTagsFromContext(cxt);
        }
        new CustomMetric(metricName, 1.0, tags).write();
    }

    @Deprecated
    public URLConnection makeUrlConnection(URL url) throws IOException {
        URLConnection uc = url.openConnection();
        return this.addTraceHeaders(uc);
    }

    @Deprecated
    public URLConnection addTraceHeaders(URLConnection urlConnection) {
        if (this.tracing == null) {
            DDLogger.getLoggerImpl().error("Unable to add trace headers from an untraceable request. Did you pass LambdaInstrumenter a request?", new Object[0]);
            return urlConnection;
        }
        Map<String, String> traceHeaders = this.tracing.makeOutboundHttpTraceHeaders();
        traceHeaders.forEach(urlConnection::setRequestProperty);
        return urlConnection;
    }

    @Deprecated
    public HttpGet makeHttpGet(String url) {
        HttpGet hg = new HttpGet(url);
        hg = (HttpGet)this.addTraceHeaders((HttpUriRequest)hg);
        return hg;
    }

    @Deprecated
    public HttpUriRequest addTraceHeaders(HttpUriRequest httpRequest) {
        if (this.tracing == null) {
            DDLogger.getLoggerImpl().error("Unable to add trace headers from an untraceable request. Did you pass LambdaInstrumenter a request?", new Object[0]);
            return httpRequest;
        }
        Map<String, String> traceHeaders = this.tracing.makeOutboundHttpTraceHeaders();
        traceHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequest)httpRequest).setHeader(arg_0, arg_1));
        return httpRequest;
    }

    @Deprecated
    public Request.Builder makeRequestBuilder() {
        Request.Builder hrb = new Request.Builder();
        Map<String, String> traceHeaders = this.tracing.makeOutboundHttpTraceHeaders();
        traceHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)hrb).addHeader(arg_0, arg_1));
        return hrb;
    }

    @Deprecated
    public Request addTraceHeaders(Request request) {
        if (this.tracing == null) {
            DDLogger.getLoggerImpl().error("Unable to add trace headers from an untraceable request. Did you pass LambdaInstrumenter a request?", new Object[0]);
            return request;
        }
        Map<String, String> traceHeaders = this.tracing.makeOutboundHttpTraceHeaders();
        Request.Builder rb = request.newBuilder();
        traceHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)rb).addHeader(arg_0, arg_1));
        return rb.build();
    }

    public Map<String, String> getTraceContext() {
        if (this.tracing == null) {
            DDLogger.getLoggerImpl().debug("No tracing context; unable to get Trace ID", new Object[0]);
            return null;
        }
        return this.tracing.getLogCorrelationTraceAndSpanIDsMap();
    }

    public String getTraceContextString() {
        Map<String, String> traceInfo = this.getTraceContext();
        if (traceInfo == null) {
            DDLogger.getLoggerImpl().debug("No Trace/Log correlation IDs returned", new Object[0]);
            return "";
        }
        String traceID = traceInfo.get(this.tracing.TRACE_ID_KEY);
        String spanID = traceInfo.get(this.tracing.SPAN_ID_KEY);
        return this.formatTraceContext(this.tracing.TRACE_ID_KEY, traceID, this.tracing.SPAN_ID_KEY, spanID);
    }

    public String getTraceContextJSONString() {
        String json = this.tracing.makeOutboundJson();
        if (json == null || json.isEmpty()) {
            DDLogger.getLoggerImpl().debug("No Trace/Log correlation IDs returned", new Object[0]);
            return "";
        }
        return json;
    }

    private String formatTraceContext(String traceKey, String trace, String spanKey, String span) {
        return String.format("[%s=%s %s=%s]", traceKey, trace, spanKey, span);
    }
}

