/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.datadoghq.datadog_lambda_java.MetricWriter;
import com.datadoghq.datadog_lambda_java.PersistedCustomMetric;
import java.util.Date;
import java.util.Map;

public class CustomMetric {
    private String name;
    private double value;
    private Map<String, Object> tags;
    private Date time;

    public CustomMetric(String name, double value, Map<String, Object> tags) {
        this(name, value, tags, new Date());
    }

    public CustomMetric(String name, double value, Map<String, Object> tags, Date time) {
        this.name = name;
        this.value = value;
        this.tags = tags;
        this.time = time;
    }

    public String toJson() {
        PersistedCustomMetric pcm = new PersistedCustomMetric(this.name, this.value, this.tags, this.time);
        return pcm.toJsonString();
    }

    public void write() {
        MetricWriter writer = MetricWriter.getMetricWriterImpl();
        writer.write(this);
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }
}

