/*
 * Decompiled with CFR 0.152.
 */
package com.twocaptcha;

import com.twocaptcha.exceptions.ApiException;
import com.twocaptcha.exceptions.NetworkException;
import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ApiClient {
    public String host = "2captcha.com";
    private final OkHttpClient client = new OkHttpClient();

    public String in(Map<String, String> params, Map<String, File> files) throws Exception {
        FormBody body;
        FormBody.Builder form;
        HttpUrl.Builder url = new HttpUrl.Builder().scheme("https").host(this.host).addPathSegment("in.php");
        if (files.size() == 0) {
            form = new FormBody.Builder();
            params.forEach((arg_0, arg_1) -> ((FormBody.Builder)form).add(arg_0, arg_1));
            body = form.build();
        } else {
            form = new MultipartBody.Builder();
            form.setType(MultipartBody.FORM);
            params.forEach((arg_0, arg_1) -> ((MultipartBody.Builder)form).addFormDataPart(arg_0, arg_1));
            for (Map.Entry<String, File> entry : files.entrySet()) {
                byte[] fileBytes = Files.readAllBytes(entry.getValue().toPath());
                form.addFormDataPart(entry.getKey(), entry.getValue().getName(), RequestBody.create((byte[])fileBytes));
            }
            body = form.build();
        }
        Request request = new Request.Builder().url(url.build()).post((RequestBody)body).build();
        return this.execute(request);
    }

    public String res(Map<String, String> params) throws Exception {
        HttpUrl.Builder url = new HttpUrl.Builder().scheme("https").host(this.host).addPathSegment("res.php");
        params.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)url).addQueryParameter(arg_0, arg_1));
        Request request = new Request.Builder().url(url.build()).build();
        return this.execute(request);
    }

    private String execute(Request request) throws Exception {
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new NetworkException("Unexpected code " + response);
            }
            String body = response.body().string();
            if (body.startsWith("ERROR_")) {
                throw new ApiException(body);
            }
            String string = body;
            return string;
        }
    }

    public void setHost(String domain) {
        this.host = domain;
    }
}

