/*
 * Decompiled with CFR 0.152.
 */
package com.twocaptcha;

import com.twocaptcha.ApiClient;
import com.twocaptcha.captcha.Captcha;
import com.twocaptcha.captcha.ReCaptcha;
import com.twocaptcha.exceptions.ApiException;
import com.twocaptcha.exceptions.NetworkException;
import com.twocaptcha.exceptions.TimeoutException;
import com.twocaptcha.exceptions.ValidationException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class TwoCaptcha {
    private String apiKey;
    private int softId = 4581;
    private String callback;
    private int defaultTimeout = 120;
    private int recaptchaTimeout = 600;
    private int pollingInterval = 10;
    private boolean lastCaptchaHasCallback;
    private int extendedResponse = 0;
    private ApiClient apiClient = new ApiClient();

    public TwoCaptcha() {
    }

    public TwoCaptcha(String apiKey) {
        this();
        this.setApiKey(apiKey);
    }

    public TwoCaptcha(String apiKey, int extendedResponse) {
        this();
        this.setApiKey(apiKey);
        this.extendedResponse = extendedResponse;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setHost(String domain) {
        this.apiClient.setHost(domain);
    }

    public void setSoftId(int softId) {
        this.softId = softId;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public void setDefaultTimeout(int timeout) {
        this.defaultTimeout = timeout;
    }

    public void setRecaptchaTimeout(int timeout) {
        this.recaptchaTimeout = timeout;
    }

    public void setPollingInterval(int interval) {
        this.pollingInterval = interval;
    }

    public void setHttpClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void solve(Captcha captcha) throws Exception {
        HashMap<String, Integer> waitOptions = new HashMap<String, Integer>();
        if (captcha instanceof ReCaptcha) {
            waitOptions.put("timeout", this.recaptchaTimeout);
        }
        this.solve(captcha, waitOptions);
    }

    public void solve(Captcha captcha, Map<String, Integer> waitOptions) throws Exception {
        captcha.setId(this.send(captcha));
        if (!this.lastCaptchaHasCallback) {
            this.waitForResult(captcha, waitOptions);
        }
    }

    public void waitForResult(Captcha captcha, Map<String, Integer> waitOptions) throws Exception {
        long now;
        long startedAt = System.currentTimeMillis() / 1000L;
        int timeout = waitOptions.getOrDefault("timeout", this.defaultTimeout);
        int pollingInterval = waitOptions.getOrDefault("pollingInterval", this.pollingInterval);
        while ((now = System.currentTimeMillis() / 1000L) - startedAt < (long)timeout) {
            Thread.sleep(pollingInterval * 1000);
            try {
                String result = this.getResult(captcha.getId());
                if (result == null) continue;
                captcha.setCode(String.valueOf(result));
                return;
            }
            catch (NetworkException networkException) {
            }
        }
        throw new TimeoutException("Timeout " + timeout + " seconds reached");
    }

    public String send(Captcha captcha) throws Exception {
        Map<String, String> params = captcha.getParams();
        Map<String, File> files = captcha.getFiles();
        this.sendAttachDefaultParams(params);
        this.validateFiles(files);
        String response = this.apiClient.in(params, files);
        return this.getCaptchaId(response);
    }

    String getCaptchaId(String response) throws ApiException {
        try {
            JSONObject jsonObject = new JSONObject(response);
            String request = jsonObject.getString("request");
            if (request.equals("CAPCHA_NOT_READY")) {
                return null;
            }
            return jsonObject.getString("request");
        }
        catch (JSONException exception) {
            if (response.equals("CAPCHA_NOT_READY")) {
                return null;
            }
            if (!response.startsWith("OK|")) {
                throw new ApiException("Cannot recognise api response (" + response + ")");
            }
            return response.substring(3);
        }
    }

    String handleResponse(String response) throws ApiException {
        try {
            JSONObject jsonObject = new JSONObject(response);
            Object requestVal = jsonObject.get("request");
            if (requestVal.equals("CAPCHA_NOT_READY")) {
                return null;
            }
            return jsonObject.toString();
        }
        catch (JSONException exception) {
            if (response.equals("CAPCHA_NOT_READY")) {
                return null;
            }
            if (!response.startsWith("OK|")) {
                throw new ApiException("Cannot recognise api response (" + response + ")");
            }
            return response.substring(3);
        }
    }

    public String getResult(String id) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "get");
        params.put("id", id);
        params.put("json", String.valueOf(this.extendedResponse));
        String response = this.res(params);
        return this.handleResponse(response);
    }

    public double balance() throws Exception {
        String response = this.res("getbalance");
        return Double.parseDouble(response);
    }

    public void report(String id, boolean correct) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        if (correct) {
            params.put("action", "reportgood");
        } else {
            params.put("action", "reportbad");
        }
        this.res(params);
    }

    private String res(String action) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", action);
        return this.res(params);
    }

    private String res(Map<String, String> params) throws Exception {
        params.put("key", this.apiKey);
        return this.apiClient.res(params);
    }

    private void sendAttachDefaultParams(Map<String, String> params) {
        params.put("key", this.apiKey);
        params.put("json", String.valueOf(this.extendedResponse));
        if (this.callback != null) {
            if (!params.containsKey("pingback")) {
                params.put("pingback", this.callback);
            } else if (params.get("pingback").length() == 0) {
                params.remove("pingback");
            }
        }
        this.lastCaptchaHasCallback = params.containsKey("pingback");
        if (this.softId != 0 && !params.containsKey("soft_id")) {
            params.put("soft_id", String.valueOf(this.softId));
        }
    }

    private void validateFiles(Map<String, File> files) throws ValidationException {
        for (Map.Entry<String, File> entry : files.entrySet()) {
            File file = entry.getValue();
            if (!file.exists()) {
                throw new ValidationException("File not found: " + file.getAbsolutePath());
            }
            if (file.isFile()) continue;
            throw new ValidationException("Resource is not a file: " + file.getAbsolutePath());
        }
    }

    public void setExtendedResponse(int extendedResponse) {
        this.extendedResponse = extendedResponse;
    }
}

