/*
 * Decompiled with CFR 0.152.
 */
package com.github.advisedtesting.core.internal;

import com.github.advisedtesting.core.ObjectFactory;
import com.github.advisedtesting.core.internal.AdviceAnnotationEvaluator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class ProviderAwareObjectFactoryAggregate
implements ObjectFactory {
    private Map<Annotation, ObjectFactory> contexts = new LinkedHashMap<Annotation, ObjectFactory>();

    public void register(Annotation annotation, ObjectFactory objectFactory) {
        this.contexts.put(annotation, objectFactory);
    }

    @Override
    public <T> T getObject(Class<T> type) {
        for (Map.Entry<Annotation, ObjectFactory> entry : this.contexts.entrySet()) {
            T found = entry.getValue().getObject(type);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public <T> T getObject(String name, Class<T> type) {
        return (T)this.contexts.entrySet().stream().map(entry -> ((ObjectFactory)entry.getValue()).getObject(name, type)).filter(o -> o != null).findFirst().orElseGet(() -> null);
    }

    public <T> T getObject(Annotation annotation, Class<T> type) {
        return (T)this.invokeOnFoundObjectFactory(annotation, o -> o.getObject(type));
    }

    public <T> T getObject(Annotation annotation, String name, Class<T> type) {
        return (T)this.invokeOnFoundObjectFactory(annotation, o -> o.getObject(name, type));
    }

    public <T> Map<String, T> getAllObjects(Annotation annotation, Class<T> type) {
        return this.invokeOnFoundObjectFactory(annotation, o -> o.getAllObjects(type));
    }

    @Override
    public <T> Map<String, T> getAllObjects(Class<T> type) {
        for (Map.Entry<Annotation, ObjectFactory> context : this.contexts.entrySet()) {
            Map<String, T> matches = context.getValue().getAllObjects(type);
            if (matches == null || matches.size() <= 0) continue;
            return matches;
        }
        return Collections.unmodifiableMap(Collections.EMPTY_MAP);
    }

    public Object[] getArgumentsFor(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = this.getArgumentFor(parameterTypes[i], annotations[i]);
        }
        return parameters;
    }

    private Object getArgumentFor(Class<?> argumentType, Annotation[] annotations) {
        Object output = null;
        Iterator<Annotation> iter = Arrays.asList(annotations).iterator();
        while (iter.hasNext() && output == null) {
            Annotation annotation = iter.next();
            String requestedInstanceName = AdviceAnnotationEvaluator.getInstanceIfPresent(annotation);
            if (requestedInstanceName != null && !"".equals(requestedInstanceName)) {
                output = this.invokeOnFoundObjectFactory(annotation, o -> o.getObject(requestedInstanceName, argumentType));
                continue;
            }
            output = this.invokeOnFoundObjectFactory(annotation, o -> o.getObject(argumentType));
        }
        return output != null ? output : (Object)this.getObject(argumentType);
    }

    private <T, X> X invokeOnFoundObjectFactory(Annotation annotation, Function<ObjectFactory, X> function) {
        String desiredName = AdviceAnnotationEvaluator.getNameIfPresent(annotation);
        for (Map.Entry<Annotation, ObjectFactory> context : this.contexts.entrySet()) {
            if (!context.getKey().annotationType().isAssignableFrom(annotation.annotationType()) || desiredName != null && !desiredName.equals(AdviceAnnotationEvaluator.getNameIfPresent(context.getKey()))) continue;
            return function.apply(context.getValue());
        }
        return null;
    }
}

