/*
 * Decompiled with CFR 0.152.
 */
package com.github.advisedtesting.core.internal;

import com.github.advisedtesting.core.ObjectFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SimpleObjectFactory
implements ObjectFactory {
    private final Map<String, Object> contents = new LinkedHashMap<String, Object>();

    public SimpleObjectFactory() {
    }

    public SimpleObjectFactory(Map<String, Object> contexts) {
        this.contents.putAll(contexts);
    }

    public void add(String name, Object value) {
        this.contents.put(name, value);
    }

    @Override
    public <T> T getObject(Class<T> type) {
        Map<String, Object> possibleOutputs = this.contents.entrySet().stream().filter(o -> type.isAssignableFrom(o.getValue().getClass())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue()));
        if (possibleOutputs.size() == 1) {
            return (T)possibleOutputs.values().iterator().next();
        }
        if (possibleOutputs.size() > 1) {
            throw new IllegalStateException("Multiple objects from the ObjectFactory can satisfy that type, but we are searching for a singleton. Matching names are " + possibleOutputs.keySet());
        }
        return null;
    }

    @Override
    public <T> T getObject(String name, Class<T> type) {
        return this.getAllObjects(type).get(name);
    }

    @Override
    public <T> Map<String, T> getAllObjects(Class<T> type) {
        HashMap output = new HashMap();
        this.contents.entrySet().forEach(e -> {
            if (e.getValue() != null && type.isAssignableFrom(e.getValue().getClass())) {
                output.put((String)e.getKey(), e.getValue());
            }
        });
        return output;
    }
}

