/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalClassLoader
extends ClassLoader {
    @Nullable
    private String basepath;
    @NotNull
    private final Map<String, Class<?>> classes = new HashMap();
    @Nullable
    private CompileException exception;

    public ExternalClassLoader() {
        super(ExternalClassLoader.class.getClassLoader());
    }

    @Override
    @Nullable
    public final Class<?> loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ExternalClassLoader.loadClass must not be null");
        }
        Class<?> c = this.classes.get(className);
        return c != null ? c : this.findClass(className);
    }

    @Override
    @Nullable
    public final Class<?> findClass(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ExternalClassLoader.findClass must not be null");
        }
        this.exception = null;
        try {
            this.checkForFile(this.basepath, className);
            Class<?> c = this.classes.get(className);
            if (c != null) {
                return c;
            }
            throw new ClassNotFoundException();
        }
        catch (ClassNotFoundException e) {
            Class<?> c = this.findSystemClass(className);
            this.classes.put(className, c);
            return c;
        }
        catch (IOException e) {
            this.exception = new CompileException(e.getMessage(), e);
            return null;
        }
        catch (CompileException e) {
            this.exception = e;
            return null;
        }
    }

    private void checkForFile(String classPath, String className) throws IOException {
        if (classPath == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ExternalClassLoader.checkForFile must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ExternalClassLoader.checkForFile must not be null");
        }
        String resource = className.replace("..", "||").replace('.', File.separatorChar).replace("||", "..");
        File javaSource = new File(classPath + File.separatorChar + resource + ".java");
        File javaClass = new File(classPath + File.separatorChar + resource + ".class");
        String absoluteClassPath = javaClass.getAbsolutePath();
        if (javaSource.exists()) {
            if (javaClass.exists()) {
                if (javaSource.lastModified() > javaClass.lastModified()) {
                    if (!javaClass.delete()) {
                        throw new CompileException("runtime compiler: unable to removed outdated .class file");
                    }
                    this.classes.remove(className);
                } else if (this.classes.get(className) == null) {
                    this.classes.put(className, this.loadClass(absoluteClassPath, className));
                }
            }
            if (!javaClass.exists()) {
                boolean status = false;
                switch (0) {
                    case 0: {
                        this.classes.put(className, this.loadClass(absoluteClassPath, className));
                        break;
                    }
                    case 1: {
                        throw new CompileException("runtime compiler: ERROR");
                    }
                    case 2: {
                        throw new CompileException("runtime compiler: CMDERR");
                    }
                    case 3: {
                        throw new CompileException("runtime compiler: SYSERR");
                    }
                    case 4: {
                        throw new CompileException("runtime compiler: ABNORMAL");
                    }
                    default: {
                        throw new CompileException("Compile status: Unknown exit status");
                    }
                }
            }
        }
    }

    private Class<?> loadClass(String classPath, String className) throws IOException {
        if (classPath == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ExternalClassLoader.loadClass must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ExternalClassLoader.loadClass must not be null");
        }
        File f = new File(classPath);
        int size = (int)f.length();
        byte[] buff = new byte[size];
        DataInputStream dis = new DataInputStream(new FileInputStream(f));
        dis.readFully(buff);
        dis.close();
        Class<?> clazz = this.defineClass(className, buff, 0, buff.length, null);
        if (clazz == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ExternalClassLoader.loadClass must not return null");
        }
        return clazz;
    }

    public void setBasepath(@Nullable String basepath) {
        this.basepath = basepath;
    }

    @Nullable
    public String getBasepath() {
        return this.basepath;
    }

    @Nullable
    public CompileException getException() {
        return this.exception;
    }

    public static class CompileException
    extends RuntimeException {
        private static final long serialVersionUID = -7210219718456902667L;

        CompileException(String reason) {
            if (reason == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ExternalClassLoader$CompileException.<init> must not be null");
            }
            super(reason);
        }

        CompileException(String reason, Throwable cause) {
            if (reason == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ExternalClassLoader$CompileException.<init> must not be null");
            }
            if (cause == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ExternalClassLoader$CompileException.<init> must not be null");
            }
            super(reason + "\n\t" + cause.toString());
            this.setStackTrace(cause.getStackTrace());
        }
    }
}

