/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.util.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bbottema.javareflection.util.graph.Node;
import org.bbottema.javareflection.util.graph.NodePathComparator;
import org.jetbrains.annotations.NotNull;

public final class GraphHelper {
    private GraphHelper() {
    }

    public static <T> boolean isPathPossible(Node<T> startingPoint, Node<T> destination) {
        if (startingPoint == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/GraphHelper.isPathPossible must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/util/graph/GraphHelper.isPathPossible must not be null");
        }
        return GraphHelper.findPossiblePaths(startingPoint, destination, new ArrayDeque<Node<T>>(), new ArrayList<List<Node<T>>>(), true, 4);
    }

    public static <T> List<List<Node<T>>> findAllPathsAscending(Node<T> startingPoint, Node<T> destination) {
        if (startingPoint == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/GraphHelper.findAllPathsAscending must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/util/graph/GraphHelper.findAllPathsAscending must not be null");
        }
        ArrayList<List<Node<T>>> allPaths = new ArrayList<List<Node<T>>>();
        GraphHelper.findPossiblePaths(startingPoint, destination, new ArrayDeque<Node<T>>(), allPaths, false, 4);
        Collections.sort(allPaths, NodePathComparator.INSTANCE());
        ArrayList<List<Node<T>>> arrayList = allPaths;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/util/graph/GraphHelper.findAllPathsAscending must not return null");
        }
        return arrayList;
    }

    private static <T> boolean findPossiblePaths(Node<T> currentNode, Node<T> destination, Deque<Node<T>> currentPath, List<List<Node<T>>> possiblePathsSoFar, boolean returnOnFirstPathFound, int cutOffEdgeCount) {
        if (currentNode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/GraphHelper.findPossiblePaths must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/util/graph/GraphHelper.findPossiblePaths must not be null");
        }
        if (currentPath == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/util/graph/GraphHelper.findPossiblePaths must not be null");
        }
        if (possiblePathsSoFar == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/util/graph/GraphHelper.findPossiblePaths must not be null");
        }
        boolean foundAPath = false;
        if (!currentPath.contains(currentNode)) {
            currentPath.addLast(currentNode);
            if (currentNode.equals(destination)) {
                if (!currentPath.isEmpty()) {
                    possiblePathsSoFar.add(new ArrayList<Node<T>>(currentPath).subList(1, currentPath.size()));
                    foundAPath = true;
                }
            } else if (currentPath.size() <= cutOffEdgeCount) {
                Node<T> nextNode;
                Iterator<Node<T>> iterator = currentNode.getToNodes().keySet().iterator();
                while (!(!iterator.hasNext() || (foundAPath |= GraphHelper.findPossiblePaths(nextNode = iterator.next(), destination, currentPath, possiblePathsSoFar, returnOnFirstPathFound, cutOffEdgeCount)) && returnOnFirstPathFound)) {
                }
            }
            currentPath.removeLast();
        }
        return foundAPath;
    }

    @NotNull
    public static <T> Set<Node<T>> findReachableNodes(Node<T> fromNode) {
        if (fromNode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/GraphHelper.findReachableNodes must not be null");
        }
        HashSet<Node<T>> reachableNodes = new HashSet<Node<T>>();
        GraphHelper.findReachableNodes(fromNode, reachableNodes);
        reachableNodes.remove(fromNode);
        HashSet<Node<T>> hashSet = reachableNodes;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/util/graph/GraphHelper.findReachableNodes must not return null");
        }
        return hashSet;
    }

    private static <T> void findReachableNodes(Node<T> currentNode, Set<Node<T>> reachableNodesSoFar) {
        if (currentNode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/GraphHelper.findReachableNodes must not be null");
        }
        if (reachableNodesSoFar == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/util/graph/GraphHelper.findReachableNodes must not be null");
        }
        for (Node<T> reachableNode : currentNode.getToNodes().keySet()) {
            if (!reachableNodesSoFar.add(reachableNode)) continue;
            GraphHelper.findReachableNodes(reachableNode, reachableNodesSoFar);
        }
    }
}

