/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class PluginInfoContainer {
    private static final Map<String, Set<String>> SPRING_REGISTER_BEAN_NAMES = new ConcurrentHashMap<String, Set<String>>();

    private PluginInfoContainer() {
        throw new IllegalStateException();
    }

    public static void addRegisterBeanName(String pluginId, String beanName) {
        if (!StringUtils.isEmpty((Object)beanName)) {
            Set beanNames = SPRING_REGISTER_BEAN_NAMES.computeIfAbsent(pluginId, k -> new HashSet());
            beanNames.add(beanName);
        }
    }

    public static void removeRegisterBeanName(String pluginId, String beanName) {
        Set<String> beanNames = SPRING_REGISTER_BEAN_NAMES.get(pluginId);
        if (beanNames != null) {
            beanNames.remove(beanName);
        }
    }

    public static boolean existRegisterBeanName(String pluginId, String beanName) {
        Set<String> beanNames = SPRING_REGISTER_BEAN_NAMES.get(pluginId);
        if (beanNames != null) {
            return beanNames.contains(beanName);
        }
        return false;
    }

    public static boolean existRegisterBeanName(String beanName) {
        for (Set<String> beanNames : SPRING_REGISTER_BEAN_NAMES.values()) {
            if (!beanNames.contains(beanName)) continue;
            return true;
        }
        return false;
    }
}

