/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory;

import com.github.codingdebugallday.realize.BasePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pf4j.PluginWrapper;

public class PluginRegistryInfo {
    private final Map<String, Object> extensionMap = new ConcurrentHashMap<String, Object>();
    private final List<Class<?>> classes = new ArrayList();
    private final Map<String, List<Class<?>>> groupClasses = new HashMap();
    private final Map<String, Object> processorInfo = new HashMap<String, Object>();
    private final PluginWrapper pluginWrapper;
    private final BasePlugin basePlugin;

    public PluginRegistryInfo(PluginWrapper pluginWrapper) {
        this.pluginWrapper = pluginWrapper;
        this.basePlugin = (BasePlugin)pluginWrapper.getPlugin();
    }

    public PluginWrapper getPluginWrapper() {
        return this.pluginWrapper;
    }

    public BasePlugin getBasePlugin() {
        return this.basePlugin;
    }

    public void addClasses(Class<?> aClass) {
        if (aClass != null) {
            this.classes.add(aClass);
        }
    }

    public void cleanClasses() {
        this.classes.clear();
    }

    public List<Class<?>> getClasses() {
        return new ArrayList(this.classes);
    }

    public void addGroupClasses(String key, Class<?> aClass) {
        List classList = this.groupClasses.computeIfAbsent(key, k -> new ArrayList());
        classList.add(aClass);
    }

    public List<Class<?>> getGroupClasses(String key) {
        ArrayList result = new ArrayList();
        List<Class<?>> classList = this.groupClasses.get(key);
        if (classList != null) {
            result.addAll(classList);
        }
        return result;
    }

    public <T> T getProcessorInfo(String key) {
        Object o = this.processorInfo.get(key);
        if (o != null) {
            return (T)o;
        }
        return null;
    }

    public void addProcessorInfo(String key, Object value) {
        this.processorInfo.put(key, value);
    }

    public void addExtension(String key, Object value) {
        if (this.extensionMap.containsKey(key)) {
            throw new IllegalArgumentException("The extension key ' " + key + " 'already exists");
        }
        this.extensionMap.put(key, value);
    }

    public void removeExtension(String key) {
        this.extensionMap.remove(key);
    }

    public <T> T getExtension(String key) {
        Object o = this.extensionMap.get(key);
        if (o != null) {
            return (T)o;
        }
        return null;
    }
}

