/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.pipe.bean;

import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.SpringBeanRegister;
import com.github.codingdebugallday.factory.process.pipe.PluginPipeProcessor;
import com.github.codingdebugallday.realize.ConfigBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ConfigBeanProcessor
implements PluginPipeProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String KEY = "ConfigBeanProcessor";
    private final SpringBeanRegister springBeanRegister;
    private final ApplicationContext applicationContext;

    public ConfigBeanProcessor(ApplicationContext applicationContext) {
        this.springBeanRegister = new SpringBeanRegister(applicationContext);
        this.applicationContext = applicationContext;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void register(PluginRegistryInfo pluginRegistryInfo) {
        List<Class<?>> configBeans = pluginRegistryInfo.getGroupClasses("config_bean");
        if (configBeans == null || configBeans.isEmpty()) {
            return;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        HashMap<String, ConfigBean> configBeanMap = new HashMap<String, ConfigBean>(8);
        for (Class<?> aClass : configBeans) {
            String name;
            Object bean;
            if (aClass == null || !((bean = this.applicationContext.getBean(name = this.springBeanRegister.register(pluginId, aClass))) instanceof ConfigBean)) continue;
            ConfigBean configBean = (ConfigBean)bean;
            configBean.initialize();
            configBeanMap.put(name, configBean);
        }
        pluginRegistryInfo.addProcessorInfo(KEY, configBeanMap);
    }

    @Override
    public void unregister(PluginRegistryInfo pluginRegistryInfo) {
        Map configBeanMap = (Map)pluginRegistryInfo.getProcessorInfo(KEY);
        if (configBeanMap == null) {
            return;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        configBeanMap.forEach((beanName, configBean) -> {
            if (configBean == null) {
                return;
            }
            try {
                configBean.destroy();
            }
            catch (Exception e) {
                this.log.error("ConfigBean '' destroy exception. {}", (Object)e.getMessage(), (Object)e);
            }
            this.springBeanRegister.unregister(pluginId, (String)beanName);
        });
    }
}

