/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.pipe.bean.name;

import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.util.StringUtils;

public class PluginAnnotationBeanNameGenerator
extends AnnotationBeanNameGenerator {
    private final String pluginId;
    private final String suffixName;

    public PluginAnnotationBeanNameGenerator(String pluginId, String suffixName) {
        this.pluginId = StringUtils.isEmpty((Object)pluginId) ? "" : pluginId + "@";
        this.suffixName = StringUtils.isEmpty((Object)suffixName) ? "" : "@" + suffixName;
    }

    public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        String beanName;
        if (definition instanceof AnnotatedBeanDefinition && StringUtils.hasText((String)(beanName = this.determineBeanNameFromAnnotation((AnnotatedBeanDefinition)definition)))) {
            return beanName;
        }
        return this.pluginId + this.buildDefaultBeanName(definition, registry) + this.suffixName;
    }
}

