/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.pipe.classs;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.extension.ExtensionInitializer;
import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.process.pipe.PluginPipeProcessor;
import com.github.codingdebugallday.factory.process.pipe.classs.PluginClassGroup;
import com.github.codingdebugallday.factory.process.pipe.classs.group.CallerGroup;
import com.github.codingdebugallday.factory.process.pipe.classs.group.ComponentGroup;
import com.github.codingdebugallday.factory.process.pipe.classs.group.ConfigBeanGroup;
import com.github.codingdebugallday.factory.process.pipe.classs.group.ConfigDefinitionGroup;
import com.github.codingdebugallday.factory.process.pipe.classs.group.ConfigurationGroup;
import com.github.codingdebugallday.factory.process.pipe.classs.group.ControllerGroup;
import com.github.codingdebugallday.factory.process.pipe.classs.group.OneselfListenerGroup;
import com.github.codingdebugallday.factory.process.pipe.classs.group.RepositoryGroup;
import com.github.codingdebugallday.factory.process.pipe.classs.group.SupplierGroup;
import com.github.codingdebugallday.loader.PluginResourceLoadFactory;
import com.github.codingdebugallday.loader.ResourceWrapper;
import com.github.codingdebugallday.realize.BasePlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class PluginClassProcess
implements PluginPipeProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String OTHER = "other";
    private final List<PluginClassGroup> pluginClassGroups = new ArrayList<PluginClassGroup>();

    @Override
    public void initialize() {
        this.pluginClassGroups.add(new ComponentGroup());
        this.pluginClassGroups.add(new ControllerGroup());
        this.pluginClassGroups.add(new RepositoryGroup());
        this.pluginClassGroups.add(new ConfigurationGroup());
        this.pluginClassGroups.add(new ConfigDefinitionGroup());
        this.pluginClassGroups.add(new ConfigBeanGroup());
        this.pluginClassGroups.add(new SupplierGroup());
        this.pluginClassGroups.add(new CallerGroup());
        this.pluginClassGroups.add(new OneselfListenerGroup());
        this.pluginClassGroups.addAll(ExtensionInitializer.getClassGroupExtends());
    }

    @Override
    public void register(PluginRegistryInfo pluginRegistryInfo) {
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        PluginResourceLoadFactory pluginResourceLoadFactory = basePlugin.getBasePluginExtend().getPluginResourceLoadFactory();
        ResourceWrapper resourceWrapper = pluginResourceLoadFactory.getPluginResources("PluginClassProcess");
        if (resourceWrapper == null) {
            return;
        }
        List<Resource> pluginResources = resourceWrapper.getResources();
        if (pluginResources == null) {
            return;
        }
        for (PluginClassGroup pluginClassGroup : this.pluginClassGroups) {
            try {
                pluginClassGroup.initialize(basePlugin);
            }
            catch (Exception e) {
                this.log.error("PluginClassGroup {} initialize exception. {}", new Object[]{pluginClassGroup.getClass(), e.getMessage(), e});
            }
        }
        this.handle(resourceWrapper, basePlugin, pluginRegistryInfo);
    }

    private void handle(ResourceWrapper resourceWrapper, BasePlugin basePlugin, PluginRegistryInfo pluginRegistryInfo) {
        Set<String> classPackageNames = resourceWrapper.getClassPackageNames();
        for (String classPackageName : classPackageNames) {
            Class<?> aClass;
            try {
                aClass = Class.forName(classPackageName, false, basePlugin.getWrapper().getPluginClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new PluginException(e);
            }
            boolean findGroup = false;
            for (PluginClassGroup pluginClassGroup : this.pluginClassGroups) {
                if (pluginClassGroup == null || StringUtils.isEmpty((Object)pluginClassGroup.groupId()) || !pluginClassGroup.filter(aClass)) continue;
                pluginRegistryInfo.addGroupClasses(pluginClassGroup.groupId(), aClass);
                findGroup = true;
            }
            if (!findGroup) {
                pluginRegistryInfo.addGroupClasses(OTHER, aClass);
            }
            pluginRegistryInfo.addClasses(aClass);
        }
    }

    @Override
    public void unregister(PluginRegistryInfo registerPluginInfo) {
        registerPluginInfo.cleanClasses();
    }
}

