/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.post;

import com.github.codingdebugallday.extension.ExtensionInitializer;
import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.process.post.PluginPostProcessor;
import com.github.codingdebugallday.factory.process.post.bean.PluginConfigurationPostProcessor;
import com.github.codingdebugallday.factory.process.post.bean.PluginControllerPostProcessor;
import com.github.codingdebugallday.factory.process.post.bean.PluginInvokePostProcessor;
import com.github.codingdebugallday.factory.process.post.bean.PluginOneselfStartEventProcessor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class PluginPostProcessorFactory
implements PluginPostProcessor {
    private final List<PluginPostProcessor> pluginPostProcessors = new ArrayList<PluginPostProcessor>();
    private final ApplicationContext applicationContext;

    public PluginPostProcessorFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void initialize() {
        this.pluginPostProcessors.addAll(ExtensionInitializer.getPostProcessorExtends());
        this.pluginPostProcessors.add(new PluginConfigurationPostProcessor(this.applicationContext));
        this.pluginPostProcessors.add(new PluginInvokePostProcessor(this.applicationContext));
        this.pluginPostProcessors.add(new PluginControllerPostProcessor(this.applicationContext));
        this.pluginPostProcessors.add(new PluginOneselfStartEventProcessor(this.applicationContext));
        for (PluginPostProcessor pluginPostProcessor : this.pluginPostProcessors) {
            pluginPostProcessor.initialize();
        }
    }

    @Override
    public void register(List<PluginRegistryInfo> pluginRegistryInfos) {
        for (PluginPostProcessor pluginPostProcessor : this.pluginPostProcessors) {
            pluginPostProcessor.register(pluginRegistryInfos);
        }
    }

    @Override
    public void unregister(List<PluginRegistryInfo> pluginRegistryInfos) {
        for (PluginPostProcessor pluginPostProcessor : this.pluginPostProcessors) {
            pluginPostProcessor.unregister(pluginRegistryInfos);
        }
    }
}

