/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.post.bean;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.extension.PluginControllerProcessor;
import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.SpringBeanRegister;
import com.github.codingdebugallday.factory.process.post.PluginPostProcessor;
import com.github.codingdebugallday.integration.IntegrationConfiguration;
import com.github.codingdebugallday.utils.AopUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class PluginControllerPostProcessor
implements PluginPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_KEY = "PluginControllerPostProcessor";
    private final SpringBeanRegister springBeanRegister;
    private final GenericApplicationContext applicationContext;
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;
    private final IntegrationConfiguration integrationConfiguration;

    public PluginControllerPostProcessor(ApplicationContext applicationContext) {
        Objects.requireNonNull(applicationContext);
        this.springBeanRegister = new SpringBeanRegister(applicationContext);
        this.applicationContext = (GenericApplicationContext)applicationContext;
        this.requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        this.integrationConfiguration = (IntegrationConfiguration)applicationContext.getBean(IntegrationConfiguration.class);
    }

    @Override
    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(List<PluginRegistryInfo> pluginRegistryInfos) {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            AopUtils.resolveAop(pluginRegistryInfo.getPluginWrapper());
            try {
                List<Class<?>> groupClasses = pluginRegistryInfo.getGroupClasses("spring_controller");
                if (groupClasses == null || groupClasses.isEmpty()) continue;
                ArrayList<ControllerBeanWrapper> controllerBeanWrappers = new ArrayList<ControllerBeanWrapper>();
                for (Class<?> groupClass : groupClasses) {
                    if (groupClass == null) continue;
                    ControllerBeanWrapper controllerBeanWrapper = this.registry(pluginRegistryInfo, groupClass);
                    controllerBeanWrappers.add(controllerBeanWrapper);
                    this.process(1, pluginRegistryInfo.getPluginWrapper().getPluginId(), groupClass);
                }
                pluginRegistryInfo.addProcessorInfo(this.getKey(pluginRegistryInfo), controllerBeanWrappers);
            }
            finally {
                AopUtils.recoverAop();
            }
        }
    }

    @Override
    public void unregister(List<PluginRegistryInfo> pluginRegistryInfos) {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            List controllerBeanWrappers = (List)pluginRegistryInfo.getProcessorInfo(this.getKey(pluginRegistryInfo));
            if (controllerBeanWrappers == null || controllerBeanWrappers.isEmpty()) continue;
            String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
            for (ControllerBeanWrapper controllerBeanWrapper : controllerBeanWrappers) {
                if (controllerBeanWrapper == null) continue;
                this.unregister(pluginId, controllerBeanWrapper);
                this.process(2, pluginRegistryInfo.getPluginWrapper().getPluginId(), controllerBeanWrapper.getBeanClass());
            }
        }
    }

    private ControllerBeanWrapper registry(PluginRegistryInfo pluginRegistryInfo, Class<?> aClass) {
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        String beanName = this.springBeanRegister.register(pluginId, aClass);
        if (beanName == null || "".equals(beanName)) {
            throw new IllegalArgumentException("registry " + aClass.getName() + "failure!");
        }
        try {
            Object object = this.applicationContext.getBean(beanName);
            ControllerBeanWrapper controllerBeanWrapper = new ControllerBeanWrapper();
            controllerBeanWrapper.setBeanName(beanName);
            this.setPathPrefix(pluginId, aClass);
            Method getMappingForMethod = ReflectionUtils.findMethod(RequestMappingHandlerMapping.class, (String)"getMappingForMethod", (Class[])new Class[]{Method.class, Class.class});
            assert (getMappingForMethod != null);
            getMappingForMethod.setAccessible(true);
            Method[] methods = aClass.getMethods();
            HashSet<RequestMappingInfo> requestMappingInfos = new HashSet<RequestMappingInfo>();
            for (Method method : methods) {
                if (!this.isHaveRequestMapping(method)) continue;
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)getMappingForMethod.invoke((Object)this.requestMappingHandlerMapping, method, aClass);
                this.requestMappingHandlerMapping.registerMapping(requestMappingInfo, object, method);
                requestMappingInfos.add(requestMappingInfo);
            }
            controllerBeanWrapper.setRequestMappingInfos(requestMappingInfos);
            controllerBeanWrapper.setBeanClass(aClass);
            return controllerBeanWrapper;
        }
        catch (Exception e) {
            this.springBeanRegister.unregister(pluginId, beanName);
            throw new PluginException(e);
        }
    }

    private void unregister(String pluginId, ControllerBeanWrapper controllerBeanWrapper) {
        String beanName;
        Set<RequestMappingInfo> requestMappingInfos = controllerBeanWrapper.getRequestMappingInfos();
        if (requestMappingInfos != null && !requestMappingInfos.isEmpty()) {
            for (RequestMappingInfo requestMappingInfo : requestMappingInfos) {
                this.requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo);
            }
        }
        if (!StringUtils.isEmpty((Object)(beanName = controllerBeanWrapper.getBeanName()))) {
            this.springBeanRegister.unregister(pluginId, beanName);
        }
    }

    private String getKey(PluginRegistryInfo registerPluginInfo) {
        return "PluginControllerPostProcessor_" + registerPluginInfo.getPluginWrapper().getPluginId();
    }

    private void setPathPrefix(String pluginId, Class<?> aClass) {
        RequestMapping requestMapping = aClass.getAnnotation(RequestMapping.class);
        if (requestMapping == null) {
            return;
        }
        String pathPrefix = this.integrationConfiguration.pluginRestControllerPathPrefix();
        if (this.integrationConfiguration.enablePluginIdRestControllerPathPrefix()) {
            pathPrefix = pathPrefix != null && !"".equals(pathPrefix) ? this.joiningPath(pathPrefix, pluginId) : pluginId;
        } else if (pathPrefix == null || "".equals(pathPrefix)) {
            return;
        }
        this.handleRequestMapping(requestMapping, pathPrefix);
    }

    private void handleRequestMapping(RequestMapping requestMapping, String pathPrefix) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(requestMapping);
        HashSet<String> definePaths = new HashSet<String>();
        definePaths.addAll(Arrays.asList(requestMapping.path()));
        definePaths.addAll(Arrays.asList(requestMapping.value()));
        try {
            Field field = invocationHandler.getClass().getDeclaredField("memberValues");
            field.setAccessible(true);
            Map memberValues = (Map)field.get(invocationHandler);
            String[] newPath = new String[definePaths.size()];
            int i = 0;
            for (String definePath : definePaths) {
                if (definePath.contains(pathPrefix)) {
                    newPath[i++] = definePath;
                    continue;
                }
                newPath[i++] = this.joiningPath(pathPrefix, definePath);
            }
            if (newPath.length == 0) {
                newPath = new String[]{pathPrefix};
            }
            memberValues.put("path", newPath);
            memberValues.put("value", new String[0]);
        }
        catch (Exception e) {
            this.log.error("Define Plugin RestController pathPrefix error : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String joiningPath(String path1, String path2) {
        if (path1 != null && path2 != null) {
            if (path1.endsWith("/") && path2.startsWith("/")) {
                return path1 + path2.substring(1);
            }
            if (!path1.endsWith("/") && !path2.startsWith("/")) {
                return path1 + "/" + path2;
            }
            return path1 + path2;
        }
        if (path1 != null) {
            return path1;
        }
        if (path2 != null) {
            return path2;
        }
        return "";
    }

    private boolean isHaveRequestMapping(Method method) {
        return AnnotationUtils.findAnnotation((Method)method, RequestMapping.class) != null;
    }

    private void process(int type, String pluginId, Class<?> aClass) {
        PluginControllerProcessor pluginControllerProcessor;
        try {
            pluginControllerProcessor = (PluginControllerProcessor)this.applicationContext.getBean(PluginControllerProcessor.class);
        }
        catch (Exception e) {
            pluginControllerProcessor = null;
        }
        if (pluginControllerProcessor == null) {
            return;
        }
        if (type == 1) {
            try {
                pluginControllerProcessor.register(pluginId, aClass);
            }
            catch (Exception e) {
                this.log.error("PluginControllerProcessor process {} {} error of register", (Object)pluginId, (Object)aClass.getName());
            }
        } else {
            try {
                pluginControllerProcessor.unregister(pluginId, aClass);
            }
            catch (Exception e) {
                this.log.error("PluginControllerProcessor process {} {} error of unregister", (Object)pluginId, (Object)aClass.getName());
            }
        }
    }

    public static final class ControllerBeanWrapper {
        private String beanName;
        private Class<?> beanClass;
        private Set<RequestMappingInfo> requestMappingInfos;

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public void setBeanClass(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public Set<RequestMappingInfo> getRequestMappingInfos() {
            return this.requestMappingInfos;
        }

        public void setRequestMappingInfos(Set<RequestMappingInfo> requestMappingInfos) {
            this.requestMappingInfos = requestMappingInfos;
        }
    }
}

