/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.post.bean;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.codingdebugallday.annotation.Caller;
import com.github.codingdebugallday.annotation.Supplier;
import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.factory.PluginInfoContainer;
import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.SpringBeanRegister;
import com.github.codingdebugallday.factory.process.post.PluginPostProcessor;
import com.github.codingdebugallday.utils.AopUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ClassUtils;

public class PluginInvokePostProcessor
implements PluginPostProcessor {
    private static final String KEY_SUPPERS = "PluginInvokePostProcessorSuppers";
    private static final String KEY_CALLERS = "PluginInvokePostProcessorCallers";
    private final GenericApplicationContext applicationContext;
    private final SpringBeanRegister springBeanRegister;

    public PluginInvokePostProcessor(ApplicationContext applicationContext) {
        Objects.requireNonNull(applicationContext);
        this.applicationContext = (GenericApplicationContext)applicationContext;
        this.springBeanRegister = new SpringBeanRegister(applicationContext);
    }

    @Override
    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(List<PluginRegistryInfo> pluginRegistryInfos) {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            AopUtils.resolveAop(pluginRegistryInfo.getPluginWrapper());
            try {
                List<Class<?>> suppers = pluginRegistryInfo.getGroupClasses("supplier");
                if (suppers == null) continue;
                this.processSupper(pluginRegistryInfo, suppers);
            }
            finally {
                AopUtils.recoverAop();
            }
        }
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            AopUtils.resolveAop(pluginRegistryInfo.getPluginWrapper());
            try {
                List<Class<?>> callers = pluginRegistryInfo.getGroupClasses("caller");
                if (callers == null) continue;
                this.processCaller(pluginRegistryInfo, callers);
            }
            finally {
                AopUtils.recoverAop();
            }
        }
    }

    @Override
    public void unregister(List<PluginRegistryInfo> pluginRegistryInfos) {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            Set supperNames = (Set)pluginRegistryInfo.getProcessorInfo(this.getKey(KEY_SUPPERS, pluginRegistryInfo));
            Set callerNames = (Set)pluginRegistryInfo.getProcessorInfo(this.getKey(KEY_CALLERS, pluginRegistryInfo));
            String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
            this.unregister(pluginId, supperNames);
            this.unregister(pluginId, callerNames);
        }
    }

    private void processSupper(PluginRegistryInfo pluginRegistryInfo, List<Class<?>> supperClasses) {
        if (supperClasses.isEmpty()) {
            return;
        }
        HashSet<String> beanNames = new HashSet<String>();
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        for (Class<?> supperClass : supperClasses) {
            if (supperClass == null || supperClass.getAnnotation(Supplier.class) == null) continue;
            Supplier supplier = supperClass.getAnnotation(Supplier.class);
            String beanName = supplier.value();
            if (PluginInfoContainer.existRegisterBeanName(beanName)) {
                String error = MessageFormat.format("Plugin {0} : Bean @Supplier name {1} already exist of {2}", pluginRegistryInfo.getPluginWrapper().getPluginId(), beanName, supperClass.getName());
                throw new PluginException(error);
            }
            this.springBeanRegister.registerOfSpecifyName(pluginId, beanName, supperClass);
            beanNames.add(beanName);
        }
        pluginRegistryInfo.addProcessorInfo(this.getKey(KEY_SUPPERS, pluginRegistryInfo), beanNames);
    }

    private void processCaller(PluginRegistryInfo pluginRegistryInfo, List<Class<?>> callerClasses) {
        if (callerClasses == null || callerClasses.isEmpty()) {
            return;
        }
        HashSet<String> beanNames = new HashSet<String>();
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        for (Class<?> callerClass : callerClasses) {
            Caller caller = callerClass.getAnnotation(Caller.class);
            if (caller == null) continue;
            Object supper = this.applicationContext.getBean(caller.value());
            String beanName = this.springBeanRegister.register(pluginId, callerClass, beanDefinition -> {
                beanDefinition.getPropertyValues().add("callerInterface", (Object)callerClass);
                beanDefinition.getPropertyValues().add("supper", supper);
                beanDefinition.setBeanClass(CallerInterfaceFactory.class);
                beanDefinition.setAutowireMode(2);
            });
            beanNames.add(beanName);
        }
        pluginRegistryInfo.addProcessorInfo(this.getKey(KEY_CALLERS, pluginRegistryInfo), beanNames);
    }

    private String getKey(String key, PluginRegistryInfo pluginRegistryInfo) {
        return key + "_" + pluginRegistryInfo.getPluginWrapper().getPluginId();
    }

    private void unregister(String pluginId, Set<String> beanNames) {
        if (beanNames == null || beanNames.isEmpty()) {
            return;
        }
        for (String beanName : beanNames) {
            this.springBeanRegister.unregister(pluginId, beanName);
        }
    }

    private static class CallerInterfaceFactory<T>
    implements FactoryBean<T> {
        private Class<T> callerInterface;
        private Object supper;

        private CallerInterfaceFactory() {
        }

        public T getObject() {
            ClassLoader classLoader = this.callerInterface.getClassLoader();
            Class[] interfaces = new Class[]{this.callerInterface};
            ProxyHandler proxy = new ProxyHandler(this.supper);
            return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)proxy);
        }

        public Class<?> getObjectType() {
            return this.callerInterface;
        }

        public boolean isSingleton() {
            return true;
        }

        public Class<T> getCallerInterface() {
            return this.callerInterface;
        }

        public void setCallerInterface(Class<T> callerInterface) {
            this.callerInterface = callerInterface;
        }

        public Object getSupper() {
            return this.supper;
        }

        public void setSupper(Object supper) {
            this.supper = supper;
        }
    }

    private static class ProxyHandler
    implements InvocationHandler {
        private final Object supplier;
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        private ProxyHandler(Object supplier) {
            this.supplier = supplier;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Caller.Method callerMethod = method.getAnnotation(Caller.Method.class);
            if (callerMethod == null) {
                return this.notAnnotationInvoke(method, args);
            }
            return this.annotationInvoke(method, callerMethod, args);
        }

        private Object annotationInvoke(Method method, Caller.Method callerMethod, Object[] args) {
            String callerMethodName = callerMethod.value();
            Class<?> aClass = this.supplier.getClass();
            Method[] methods = aClass.getMethods();
            Method supplierMethod = null;
            for (Method m : methods) {
                Supplier.Method supplierMethodAnnotation = m.getAnnotation(Supplier.Method.class);
                if (supplierMethodAnnotation == null || !Objects.equals(supplierMethodAnnotation.value(), callerMethodName)) continue;
                supplierMethod = m;
                break;
            }
            if (supplierMethod == null) {
                return this.notAnnotationInvoke(method, args);
            }
            Class<?>[] parameterTypes = supplierMethod.getParameterTypes();
            if (parameterTypes.length != args.length) {
                return this.notAnnotationInvoke(method, args);
            }
            try {
                Object[] supplierArgs = new Object[args.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Object serializeObject;
                    Class<?> parameterType = parameterTypes[i];
                    Object arg = args[i];
                    if (parameterType == arg.getClass()) {
                        supplierArgs[i] = arg;
                        continue;
                    }
                    String json = OBJECT_MAPPER.writeValueAsString(arg);
                    supplierArgs[i] = serializeObject = OBJECT_MAPPER.readValue(json, parameterType);
                }
                Object invokeReturn = supplierMethod.invoke(this.supplier, supplierArgs);
                return this.getReturnObject(invokeReturn, method);
            }
            catch (JsonProcessingException | IllegalAccessException | InvocationTargetException e) {
                throw new PluginException(e);
            }
        }

        private Object notAnnotationInvoke(Method method, Object[] args) {
            String name = method.getName();
            Class[] argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i].getClass();
            }
            try {
                Method supplierMethod = this.supplier.getClass().getMethod(name, argClasses);
                Object invokeReturn = supplierMethod.invoke(this.supplier, args);
                return this.getReturnObject(invokeReturn, method);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new PluginException(e);
            }
        }

        private Object getReturnObject(Object invokeReturn, Method method) {
            if (invokeReturn == null) {
                return null;
            }
            Class<?> returnType = method.getReturnType();
            if (ClassUtils.isAssignable(invokeReturn.getClass(), returnType)) {
                return invokeReturn;
            }
            try {
                String json = OBJECT_MAPPER.writeValueAsString(invokeReturn);
                return OBJECT_MAPPER.readValue(json, OBJECT_MAPPER.getTypeFactory().constructType(method.getGenericReturnType()));
            }
            catch (JsonProcessingException e) {
                throw new PluginException(e);
            }
        }
    }
}

