/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.post.bean;

import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.process.post.PluginPostProcessor;
import com.github.codingdebugallday.integration.application.PluginApplication;
import com.github.codingdebugallday.integration.user.PluginUser;
import com.github.codingdebugallday.realize.BasePlugin;
import com.github.codingdebugallday.realize.OneselfListener;
import com.github.codingdebugallday.utils.AopUtils;
import com.github.codingdebugallday.utils.CommonUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PluginOneselfStartEventProcessor
implements PluginPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PluginUser pluginUser;

    public PluginOneselfStartEventProcessor(ApplicationContext applicationContext) {
        Objects.requireNonNull(applicationContext);
        PluginApplication pluginApplication = (PluginApplication)applicationContext.getBean(PluginApplication.class);
        this.pluginUser = pluginApplication.getPluginUser();
    }

    @Override
    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(List<PluginRegistryInfo> pluginRegistryInfos) {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            AopUtils.resolveAop(pluginRegistryInfo.getPluginWrapper());
            try {
                BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
                String pluginId = basePlugin.getWrapper().getPluginId();
                List<OneselfListener> oneselfListeners = this.pluginUser.getPluginBeans(pluginId, OneselfListener.class);
                oneselfListeners.stream().sorted(CommonUtils.orderPriority(OneselfListener::order)).forEach(oneselfListener -> {
                    try {
                        oneselfListener.startEvent(basePlugin);
                    }
                    catch (Exception e) {
                        this.log.error("OneselfListener {} execute startEvent exception. {}", new Object[]{oneselfListener.getClass().getName(), e.getMessage(), e});
                    }
                });
            }
            finally {
                AopUtils.recoverAop();
            }
        }
    }

    @Override
    public void unregister(List<PluginRegistryInfo> pluginRegistryInfos) {
    }
}

