/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.listener;

import com.github.codingdebugallday.integration.listener.DefaultInitializerListener;
import com.github.codingdebugallday.integration.listener.PluginInitializerListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PluginInitializerListenerFactory
implements PluginInitializerListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<PluginInitializerListener> pluginInitializerListeners = new ArrayList<PluginInitializerListener>();
    public final ApplicationContext applicationContext;

    public PluginInitializerListenerFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.pluginInitializerListeners.add(new DefaultInitializerListener(applicationContext));
    }

    @Override
    public void before() {
        try {
            for (PluginInitializerListener pluginInitializerListener : this.pluginInitializerListeners) {
                pluginInitializerListener.before();
            }
        }
        catch (Exception e) {
            this.log.error("before error,", (Throwable)e);
        }
    }

    @Override
    public void complete() {
        try {
            for (PluginInitializerListener pluginInitializerListener : this.pluginInitializerListeners) {
                pluginInitializerListener.complete();
            }
        }
        catch (Exception e) {
            this.log.error("complete error,", (Throwable)e);
        }
    }

    @Override
    public void failure(Throwable throwable) {
        try {
            for (PluginInitializerListener pluginInitializerListener : this.pluginInitializerListeners) {
                pluginInitializerListener.failure(throwable);
            }
        }
        catch (Exception e) {
            this.log.error("failure error,", (Throwable)e);
        }
    }

    public void addPluginInitializerListeners(PluginInitializerListener pluginInitializerListener) {
        if (pluginInitializerListener != null) {
            this.pluginInitializerListeners.add(pluginInitializerListener);
        }
    }
}

