/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.listener;

import com.github.codingdebugallday.integration.listener.PluginListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.support.GenericApplicationContext;

public class PluginListenerFactory
implements PluginListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<PluginListener> listeners = new ArrayList<PluginListener>();
    private final List<Class<?>> listenerClasses = new ArrayList();

    @Override
    public void register(String pluginId) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.register(pluginId);
            }
            catch (Exception e) {
                this.log.error("listener registry error,", (Throwable)e);
            }
        }
    }

    @Override
    public void unregister(String pluginId) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.unregister(pluginId);
            }
            catch (Exception e) {
                this.log.error("listener unregister error,", (Throwable)e);
            }
        }
    }

    @Override
    public void failure(String pluginId, Throwable throwable) {
        for (PluginListener listener : this.listeners) {
            try {
                listener.failure(pluginId, throwable);
            }
            catch (Exception e) {
                this.log.error("listener failure error,", (Throwable)e);
            }
        }
    }

    public void addPluginListener(PluginListener pluginListener) {
        if (pluginListener != null) {
            this.listeners.add(pluginListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginListener> void addPluginListener(Class<T> pluginListenerClass) {
        if (pluginListenerClass != null) {
            List<Class<?>> list = this.listenerClasses;
            synchronized (list) {
                this.listenerClasses.add(pluginListenerClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginListener> void buildListenerClass(GenericApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        List<Class<?>> list = this.listenerClasses;
        synchronized (list) {
            for (Class<?> listenerClass : this.listenerClasses) {
                applicationContext.registerBeanDefinition(listenerClass.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(listenerClass).getBeanDefinition());
                PluginListener bean = (PluginListener)applicationContext.getBean(listenerClass);
                this.listeners.add(bean);
            }
            this.listenerClasses.clear();
        }
    }

    public List<PluginListener> getListeners() {
        return this.listeners;
    }

    public List<Class<?>> getListenerClasses() {
        return this.listenerClasses;
    }
}

