/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.operator.verify;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.integration.operator.verify.PluginLegalVerify;
import java.nio.file.Path;
import java.util.Objects;
import org.pf4j.CompoundPluginDescriptorFinder;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.pf4j.PropertiesPluginDescriptorFinder;

public class DefaultPluginVerify
extends PluginLegalVerify {
    private final PluginManager pluginManager;

    public DefaultPluginVerify(PluginManager pluginManager) {
        super((PluginDescriptorFinder)new CompoundPluginDescriptorFinder().add((PluginDescriptorFinder)new ManifestPluginDescriptorFinder()).add((PluginDescriptorFinder)new PropertiesPluginDescriptorFinder()));
        Objects.requireNonNull(pluginManager);
        this.pluginManager = pluginManager;
    }

    @Override
    protected Path postVerify(Path path, PluginDescriptor pluginDescriptor) {
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginDescriptor.getPluginId());
        if (pluginWrapper == null) {
            return path;
        }
        PluginDescriptor runPluginDescriptor = pluginWrapper.getDescriptor();
        String errorMsg = "The plugin (id:<" + runPluginDescriptor.getPluginId() + "> ; version <" + runPluginDescriptor.getVersion() + "> ) is already exist in the current environment\u3002 Please uninstall the plugin, then upload and update the plugin";
        throw new PluginException(errorMsg);
    }
}

