/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.operator.verify;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.integration.operator.verify.PluginVerify;
import java.nio.file.Path;
import java.util.Objects;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.springframework.util.StringUtils;

public class PluginLegalVerify
implements PluginVerify {
    protected final PluginDescriptorFinder pluginDescriptorFinder;

    public PluginLegalVerify(PluginDescriptorFinder pluginDescriptorFinder) {
        Objects.requireNonNull(pluginDescriptorFinder);
        this.pluginDescriptorFinder = pluginDescriptorFinder;
    }

    @Override
    public Path verify(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path can not be null");
        }
        if (!this.pluginDescriptorFinder.isApplicable(path)) {
            throw new PluginException(path.toString() + " : plugin illegal");
        }
        PluginDescriptor pluginDescriptor = this.pluginDescriptorFinder.find(path);
        if (pluginDescriptor == null) {
            throw new PluginException(path.toString() + " : Not found plugin Descriptor");
        }
        if (StringUtils.isEmpty((Object)pluginDescriptor.getPluginId())) {
            throw new PluginException(path.toString() + " : Plugin id can't be empty");
        }
        if (StringUtils.isEmpty((Object)pluginDescriptor.getPluginClass())) {
            throw new PluginException(path.toString() + " : Not found plugin Class");
        }
        return this.postVerify(path, pluginDescriptor);
    }

    protected Path postVerify(Path path, PluginDescriptor pluginDescriptor) {
        return path;
    }
}

