/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.integration.pf4j;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PropertiesPluginDescriptorFinder;

class ResolvePropertiesPluginDescriptorFinder
extends PropertiesPluginDescriptorFinder {
    ResolvePropertiesPluginDescriptorFinder() {
    }

    protected Properties readProperties(Path pluginPath) {
        Path propertiesPath = this.getPropertiesPath(pluginPath, this.propertiesFileName);
        if (propertiesPath == null) {
            throw new PluginRuntimeException("Cannot find the properties path");
        }
        if (Files.notExists(propertiesPath, new LinkOption[0])) {
            throw new PluginRuntimeException("Cannot find '{}' path", new Object[]{propertiesPath});
        }
        Properties properties = new Properties();
        try (InputStreamReader input = new InputStreamReader(Files.newInputStream(propertiesPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            properties.load(input);
        }
        catch (IOException e) {
            throw new PluginRuntimeException((Throwable)e);
        }
        return properties;
    }
}

