/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.realize;

import com.github.codingdebugallday.loader.PluginResourceLoadFactory;
import com.github.codingdebugallday.realize.BasePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasePluginExtend {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BasePlugin basePlugin;
    private final PluginResourceLoadFactory pluginResourceLoadFactory;
    private Long startTimestamp;
    private Long stopTimestamp;

    BasePluginExtend(BasePlugin basePlugin) {
        this.basePlugin = basePlugin;
        this.pluginResourceLoadFactory = new PluginResourceLoadFactory();
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Long getStopTimestamp() {
        return this.stopTimestamp;
    }

    public PluginResourceLoadFactory getPluginResourceLoadFactory() {
        return this.pluginResourceLoadFactory;
    }

    void startEvent() {
        try {
            this.pluginResourceLoadFactory.load(this.basePlugin);
        }
        catch (Exception e) {
            this.log.error("load error", (Throwable)e);
        }
        finally {
            this.startTimestamp = System.currentTimeMillis();
        }
    }

    void deleteEvent() {
        try {
            this.pluginResourceLoadFactory.unload(this.basePlugin);
        }
        catch (Exception e) {
            this.log.error("unload error", (Throwable)e);
        }
    }

    void stopEvent() {
        try {
            this.pluginResourceLoadFactory.unload(this.basePlugin);
        }
        catch (Exception e) {
            this.log.error("unload error", (Throwable)e);
        }
        finally {
            this.stopTimestamp = System.currentTimeMillis();
        }
    }
}

