/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.utils;

import com.github.codingdebugallday.exceptions.PluginException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyProcessorSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

public class AopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AopUtils.class);
    private static final AtomicBoolean isRecover = new AtomicBoolean(true);
    private static final List<ProxyWrapper> PROXY_WRAPPERS = new ArrayList<ProxyWrapper>();

    private AopUtils() {
    }

    public static synchronized void registered(ApplicationContext applicationContext) {
        Map beansOfType = applicationContext.getBeansOfType(ProxyProcessorSupport.class);
        if (beansOfType.isEmpty()) {
            LOG.warn("Not found ProxyProcessorSupports, And Plugin AOP can't used");
            return;
        }
        for (ProxyProcessorSupport support : beansOfType.values()) {
            if (support == null) continue;
            ProxyWrapper proxyWrapper = new ProxyWrapper();
            proxyWrapper.setProxyProcessorSupport(support);
            PROXY_WRAPPERS.add(proxyWrapper);
        }
    }

    public static synchronized void resolveAop(PluginWrapper pluginWrapper) {
        if (PROXY_WRAPPERS.isEmpty()) {
            LOG.warn("ProxyProcessorSupports is empty, And Plugin AOP can't used");
            return;
        }
        if (!isRecover.get()) {
            throw new PluginException("Not invoking resolveAop(). And can not AopUtils.resolveAop");
        }
        isRecover.set(false);
        ClassLoader pluginClassLoader = pluginWrapper.getPluginClassLoader();
        for (ProxyWrapper proxyWrapper : PROXY_WRAPPERS) {
            ProxyProcessorSupport proxyProcessorSupport = proxyWrapper.getProxyProcessorSupport();
            ClassLoader classLoader = AopUtils.getClassLoader(proxyProcessorSupport);
            proxyWrapper.setOriginalClassLoader(classLoader);
            proxyProcessorSupport.setProxyClassLoader(pluginClassLoader);
        }
    }

    public static synchronized void recoverAop() {
        if (PROXY_WRAPPERS.isEmpty()) {
            return;
        }
        for (ProxyWrapper proxyWrapper : PROXY_WRAPPERS) {
            ProxyProcessorSupport proxyProcessorSupport = proxyWrapper.getProxyProcessorSupport();
            proxyProcessorSupport.setProxyClassLoader(proxyWrapper.getOriginalClassLoader());
        }
        isRecover.set(true);
    }

    private static ClassLoader getClassLoader(ProxyProcessorSupport proxyProcessorSupport) {
        Class<?> aClass = proxyProcessorSupport.getClass();
        while (aClass != null) {
            if (aClass != ProxyProcessorSupport.class) {
                aClass = aClass.getSuperclass();
                continue;
            }
            Field[] declaredFields = aClass.getDeclaredFields();
            if (declaredFields.length == 0) break;
            for (Field field : declaredFields) {
                if (!Objects.equals("proxyClassLoader", field.getName()) && field.getType() != ClassLoader.class) continue;
                field.setAccessible(true);
                try {
                    Object o = field.get(proxyProcessorSupport);
                    if (o instanceof ClassLoader) {
                        return (ClassLoader)o;
                    }
                    LOG.warn("Get {} classLoader type not is ClassLoader type,  And Return DefaultClassLoader", (Object)aClass.getName());
                    return ClassUtils.getDefaultClassLoader();
                }
                catch (IllegalAccessException e) {
                    LOG.error("Get {} classLoader failure {}, And Return DefaultClassLoader", (Object)aClass.getName(), (Object)e.getMessage());
                    return ClassUtils.getDefaultClassLoader();
                }
            }
        }
        LOG.warn("Not found classLoader field, And Return DefaultClassLoader");
        return ClassUtils.getDefaultClassLoader();
    }

    private static class ProxyWrapper {
        ProxyProcessorSupport proxyProcessorSupport;
        ClassLoader originalClassLoader;

        private ProxyWrapper() {
        }

        ProxyProcessorSupport getProxyProcessorSupport() {
            return this.proxyProcessorSupport;
        }

        void setProxyProcessorSupport(ProxyProcessorSupport proxyProcessorSupport) {
            this.proxyProcessorSupport = proxyProcessorSupport;
        }

        ClassLoader getOriginalClassLoader() {
            return this.originalClassLoader;
        }

        void setOriginalClassLoader(ClassLoader originalClassLoader) {
            this.originalClassLoader = originalClassLoader;
        }

        public String toString() {
            return "ProxyWrapper{proxyProcessorSupport=" + this.proxyProcessorSupport + ", originalClassLoader=" + this.originalClassLoader + '}';
        }
    }
}

