/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.utils;

import com.github.codingdebugallday.utils.OrderPriority;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.springframework.util.CollectionUtils;

public class CommonUtils {
    private CommonUtils() {
    }

    public static <T> List<T> order(List<T> list, Function<T, Integer> orderImpl) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        list.sort(Comparator.comparing(orderImpl, Comparator.nullsLast(Comparator.reverseOrder())));
        return list;
    }

    public static <T> Comparator<T> orderPriority(Function<T, OrderPriority> order) {
        return Comparator.comparing(t -> {
            OrderPriority orderPriority = (OrderPriority)order.apply(t);
            if (orderPriority == null) {
                orderPriority = OrderPriority.getLowPriority();
            }
            return orderPriority.getPriority();
        }, Comparator.nullsLast(Comparator.reverseOrder()));
    }
}

