/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import configuration.ClassContainerAdjuster;
import initialization.InitDefaultValues;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import templateInput.ClassContainer;
import templateInput.definition.MethodDefinition;
import templateInput.definition.VariableDefinition;

public class DefaultAdjusters {
    public static ClassContainerAdjuster removeDepracatedFields() {
        return p -> DefaultAdjusters.removeVariableIf(p, var -> var.getAnnotations().contains("Deprecated"));
    }

    public static ClassContainerAdjuster removeStaticFields() {
        return p -> DefaultAdjusters.removeVariableIf(p, var -> var.getAccessModifiers().contains("static"));
    }

    public static ClassContainerAdjuster replaceFieldPrimitivesWithObjects() {
        return p -> DefaultAdjusters.changeVariable(p, var -> var.setType(InitDefaultValues.getObjectForPrimitive(var.getType().toString())));
    }

    public static ClassContainerAdjuster removeVoidMethods() {
        return p -> DefaultAdjusters.removeMethodIf(p, met -> met.getType().toString().equals("void"));
    }

    public static void changeVariable(ClassContainer parameters, Consumer<VariableDefinition> parameterChanger) {
        List<? extends VariableDefinition> fields = parameters.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            parameterChanger.accept(fields.get(i));
        }
    }

    public static void removeVariableIf(ClassContainer parameters, Function<VariableDefinition, Boolean> removeIfTrue) {
        List<? extends VariableDefinition> fields = parameters.getFields();
        int i = 0;
        while (i < fields.size()) {
            if (removeIfTrue.apply(fields.get(i)).booleanValue()) {
                fields.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static void removeMethodIf(ClassContainer parameters, Function<MethodDefinition, Boolean> removeIfTrue) {
        List<? extends MethodDefinition> methods = parameters.getMethods();
        int i = 0;
        while (i < methods.size()) {
            if (removeIfTrue.apply(methods.get(i)).booleanValue()) {
                methods.remove(i);
                continue;
            }
            ++i;
        }
    }
}

