/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import develop.toolkit.base.struct.CollectionInMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class Sorter<K, V> {
    private CollectionInMap<K, V> map = new CollectionInMap(key -> new LinkedList());
    private SortFunction<K, V> sortFunction;

    public Sorter(@NonNull SortFunction<K, V> sortFunction) {
        if (sortFunction == null) {
            throw new NullPointerException("sortFunction is marked non-null but is null");
        }
        this.sortFunction = sortFunction;
    }

    public void sort(Collection<V> collection) {
        for (V item : collection) {
            K key = this.sortFunction.sort(item);
            this.map.addItemSoft(key, item);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public List<V> getSingleList(K key) {
        if (this.map.containsKey(key)) {
            return new ArrayList((Collection)this.map.get(key));
        }
        return Collections.EMPTY_LIST;
    }

    public Set<K> allKey() {
        return this.map.keySet();
    }

    @FunctionalInterface
    public static interface SortFunction<K, V> {
        public K sort(V var1);
    }
}

