/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;

public final class IOAdvice {
    public static Stream<String> readLines(String filename) throws IOException {
        return IOAdvice.readLines(filename, StandardCharsets.UTF_8);
    }

    public static Stream<String> readLines(String filename, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), charset));){
            Stream<String> stream = reader.lines();
            return stream;
        }
    }

    public static Stream<String> readLines(InputStream inputStream) throws IOException {
        return IOAdvice.readLines(inputStream, StandardCharsets.UTF_8);
    }

    public static Stream<String> readLines(InputStream inputStream, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            Stream<String> stream = reader.lines();
            return stream;
        }
    }

    public static void writeLines(List<String> lines, String filename, Charset charset) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), charset));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
    }

    public static void writeLines(List<String> lines, OutputStream outputStream, Charset charset) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
    }

    public static void printFile(String filename, Charset charset) throws IOException {
        IOAdvice.readLines(filename, charset).forEach(System.out::println);
    }

    public static void printInputStream(InputStream inputStream, Charset charset) throws IOException {
        IOAdvice.readLines(inputStream, charset).forEach(System.out::println);
    }
}

