/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import develop.toolkit.base.utils.DateTimeAdvice;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class StopWatch {
    public static final String DEFAULT_NAME = "default";
    private Map<String, Instant> startInstantMap = new ConcurrentHashMap<String, Instant>();

    private StopWatch() {
        this.start(DEFAULT_NAME);
    }

    public void start(String name) {
        this.startInstantMap.put(name, Instant.now());
    }

    public long end() {
        return this.end(DEFAULT_NAME);
    }

    public long end(String name) {
        Instant end = Instant.now();
        return end.toEpochMilli() - this.startInstantMap.get(name).toEpochMilli();
    }

    public String formatEnd(String label) {
        return label + ": " + DateTimeAdvice.millisecondPretty(this.end());
    }

    public String formatEnd(String label, String name) {
        return label + ": " + DateTimeAdvice.millisecondPretty(this.end(name));
    }

    public static StopWatch start() {
        return new StopWatch();
    }
}

