/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import lombok.NonNull;

public class CollectionInMap<K, V>
extends ConcurrentHashMap<K, Collection<V>>
implements Serializable {
    private static final long serialVersionUID = 3068493190714636107L;
    private CollectionProvider collectionProvider;

    public CollectionInMap() {
        this.collectionProvider = k -> new LinkedList();
    }

    public CollectionInMap(@NonNull CollectionProvider collectionProvider) {
        if (collectionProvider == null) {
            throw new NullPointerException("collectionProvider is marked non-null but is null");
        }
        this.collectionProvider = collectionProvider;
    }

    public CollectionInMap(int initialCapacity, @NonNull CollectionProvider collectionProvider) {
        super(initialCapacity);
        if (collectionProvider == null) {
            throw new NullPointerException("collectionProvider is marked non-null but is null");
        }
        this.collectionProvider = collectionProvider;
    }

    public void addItem(K key, V item) {
        if (!this.containsKey(key)) {
            throw new IllegalStateException("key \"\" is not exist.");
        }
        Collection collection = (Collection)this.get(key);
        collection.add(item);
    }

    public void addAllItem(K key, @NonNull Collection<V> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (!this.containsKey(key)) {
            throw new IllegalStateException("key \"\" is not exist.");
        }
        Collection collection = (Collection)this.get(key);
        collection.addAll(items);
    }

    public void addItemSoft(K key, V item) {
        if (this.containsKey(key)) {
            Collection collection = (Collection)this.get(key);
            collection.add(item);
        } else {
            Collection collection = this.collectionProvider.provide(key);
            collection.add(item);
            this.put(key, collection);
        }
    }

    public void addAllItemSoft(K key, @NonNull Collection<V> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (this.containsKey(key)) {
            Collection collection = (Collection)this.get(key);
            collection.addAll(items);
        } else {
            Collection collection = this.collectionProvider.provide(key);
            collection.addAll(items);
            this.put(key, collection);
        }
    }

    public void removeItem(K key, V item) {
        if (!this.containsKey(key)) {
            throw new IllegalStateException("key \"" + key + "\" is not exist.");
        }
        Collection collection = (Collection)this.get(key);
        collection.remove(item);
    }

    public void removeIfItem(K key, @NonNull Predicate<? super V> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (!this.containsKey(key)) {
            throw new IllegalStateException("key \"" + key + "\" is not exist.");
        }
        Collection collection = (Collection)this.get(key);
        collection.removeIf(filter);
    }

    @FunctionalInterface
    public static interface CollectionProvider<K, V> {
        public Collection<V> provide(K var1);
    }
}

