/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct;

import develop.toolkit.base.struct.Pager;
import java.io.Serializable;
import java.util.List;

public class PagerResult<T>
implements Serializable {
    private static final long serialVersionUID = -3028130281925624773L;
    private List<T> list;
    private long recordTotal;
    private Pager pager;
    private long pageTotal;

    public PagerResult(Pager pager, List<T> list, long recordTotal) {
        this.list = list;
        this.recordTotal = recordTotal;
        this.pager = pager;
        this.pageTotal = recordTotal % (long)pager.getSize() == 0L ? recordTotal / (long)pager.getSize() : recordTotal / (long)pager.getSize() + 1L;
    }

    public PagerResult(int page, int size, List<T> list, long total) {
        this(new Pager(page, size), list, total);
    }

    public static <T> PagerResult<T> empty(Class<T> clazz, int page, int size) {
        return new PagerResult(page, size, List.of(), 0L);
    }

    public static <T> PagerResult<T> empty(Class<T> clazz) {
        return new PagerResult(new Pager(), List.of(), 0L);
    }

    public List<T> getList() {
        return this.list;
    }

    public long getRecordTotal() {
        return this.recordTotal;
    }

    public Pager getPager() {
        return this.pager;
    }

    public long getPageTotal() {
        return this.pageTotal;
    }

    public PagerResult() {
    }
}

