/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.struct.CollectionInMap;
import develop.toolkit.base.struct.TwoValues;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class CollectionAdvice {
    public static <E, R> boolean contains(@NonNull Collection<E> collection, R target, @NonNull Function<E, R> function) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        for (E item : collection) {
            R value = function.apply(item);
            if (target == null) {
                return value == null;
            }
            if (!target.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static <E, R> Optional<E> getFirstMatch(@NonNull Collection<E> collection, R target, @NonNull Function<E, R> function) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        for (E item : collection) {
            R value = function.apply(item);
            if (target == null) {
                return value == null ? Optional.ofNullable(item) : Optional.empty();
            }
            if (!target.equals(value)) continue;
            return Optional.ofNullable(item);
        }
        return Optional.empty();
    }

    public static <E> Optional<E> getFirstTrue(@NonNull Collection<E> collection, @NonNull Predicate<E> predicate) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        for (E item : collection) {
            if (!predicate.test(item)) continue;
            return Optional.ofNullable(item);
        }
        return Optional.empty();
    }

    public static <E> Optional<E> getFirstFalse(@NonNull Collection<E> collection, @NonNull Predicate<E> predicate) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        for (E item : collection) {
            if (predicate.test(item)) continue;
            return Optional.ofNullable(item);
        }
        return Optional.empty();
    }

    public static <E, R> List<E> getAllMatch(@NonNull Collection<E> collection, R target, @NonNull Function<E, R> function) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return collection.stream().filter(item -> {
            Object value = function.apply(item);
            if (target == null) {
                return value == null;
            }
            return target.equals(value);
        }).collect(Collectors.toList());
    }

    public static <E, K, V> Map<K, V> toMap(@NonNull Collection<E> collection, @NonNull Function<E, K> keySupplier, @NonNull Function<E, V> valueSupplier) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (keySupplier == null) {
            throw new NullPointerException("keySupplier is marked non-null but is null");
        }
        if (valueSupplier == null) {
            throw new NullPointerException("valueSupplier is marked non-null but is null");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (E item : collection) {
            map.put(keySupplier.apply(item), valueSupplier.apply(item));
        }
        return map;
    }

    @SafeVarargs
    public static <E> Set<E> union(Collection<E> master, Collection<E> ... other) {
        HashSet<E> set = new HashSet<E>(master);
        for (Collection<E> collection : other) {
            set.addAll(collection);
        }
        return set;
    }

    @SafeVarargs
    public static <E> Set<E> intersection(Collection<E> master, Collection<E> ... other) {
        HashSet<Object> set = new HashSet<Object>(master);
        for (Collection<E> collection : other) {
            set.removeIf(Predicate.not(collection::contains));
        }
        return set;
    }

    public static <E, T> CollectionInMap<E, T> associate(Collection<E> master, Collection<T> target, AssociatePredicate<E, T> predicate) {
        CollectionInMap<E, T> map = new CollectionInMap<E, T>();
        for (E e : master) {
            for (T t : target) {
                if (!predicate.test(e, t)) continue;
                map.addItemSoft(e, t);
            }
        }
        return map;
    }

    public static <E> TwoValues<List<E>, List<E>> partition(Collection<E> collection, Predicate<E> predicate) {
        LinkedList<E> match = new LinkedList<E>();
        LinkedList<E> notMatch = new LinkedList<E>();
        for (E e : collection) {
            if (predicate.test(e)) {
                match.add(e);
                continue;
            }
            notMatch.add(e);
        }
        return TwoValues.of(match, notMatch);
    }

    public static <E> List<TwoValues<E, E>> zip(List<E> master, List<E> other) {
        if (master.size() != other.size()) {
            throw new IllegalArgumentException("list size must be some");
        }
        LinkedList<TwoValues<TwoValues<E, E>, TwoValues<E, E>>> list = new LinkedList<TwoValues<TwoValues<E, E>, TwoValues<E, E>>>();
        for (int i = 0; i < master.size(); ++i) {
            list.add(TwoValues.of(master.get(i), other.get(i)));
        }
        return list;
    }

    public static interface AssociatePredicate<E, T> {
        public boolean test(E var1, T var2);
    }
}

