/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.constants.DateFormatConstants;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class DateTimeAdvice {
    public static String now() {
        return DateTimeAdvice.format(LocalDateTime.now());
    }

    public static String format(Date date) {
        return DateTimeAdvice.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static LocalDateTime parseStandard(CharSequence dateStr) {
        return LocalDateTime.parse(dateStr, DateFormatConstants.STANDARD_FORMATTER);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String format(LocalDateTime localDateTime) {
        return DateTimeAdvice.format(localDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeAdvice.toLocalDateTime(date).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeAdvice.toLocalDateTime(date).toLocalTime();
    }

    public static Instant toInstant(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant();
    }

    public static Date fromLocalDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date fromLocalDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        LocalTime localTime = LocalTime.of(0, 0, 0, 0);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        return DateTimeAdvice.fromLocalDateTime(localDateTime);
    }

    public static Date fromLocalTime(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.now(), localTime);
        return DateTimeAdvice.fromLocalDateTime(localDateTime);
    }

    public static Date fromInstant(Instant instant) {
        if (instant == null) {
            return null;
        }
        return Date.from(instant);
    }

    public static boolean isSameMonth(LocalDate day1, LocalDate day2) {
        return day1.getYear() == day2.getYear() && day1.getMonth().getValue() == day2.getMonth().getValue();
    }

    public static String millisecondPretty(long millisecond) {
        if (millisecond < 1000L) {
            return millisecond + "ms";
        }
        if (millisecond < 60000L) {
            return millisecond / 1000L + "s" + millisecond % 1000L + "ms";
        }
        if (millisecond < 3600000L) {
            long minute = millisecond / 60000L;
            long second = (millisecond - minute * 60000L) / 1000L;
            long milli = millisecond % 1000L;
            return minute + "m" + second + "s" + milli + "ms";
        }
        if (millisecond < 86400000L) {
            long hour = millisecond / 3600000L;
            long minute = (millisecond - hour * 3600000L) / 60000L;
            long second = (millisecond - hour * 3600000L - minute * 60000L) / 1000L;
            long milli = millisecond % 1000L;
            return hour + "h" + minute + "m" + second + "s" + milli + "ms";
        }
        long day = millisecond / 86400000L;
        long hour = (millisecond - day * 86400000L) / 3600000L;
        long minute = (millisecond - day * 86400000L - hour * 3600000L) / 60000L;
        long second = (millisecond - day * 86400000L - hour * 3600000L - minute * 60000L) / 1000L;
        long milli = millisecond % 1000L;
        return day + "d" + hour + "h" + minute + "m" + second + "s" + milli + "ms";
    }
}

