/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.NonNull;

public final class IOAdvice {
    public static Stream<String> readLines(String filename) throws IOException {
        return IOAdvice.readLines(filename, StandardCharsets.UTF_8);
    }

    public static Stream<String> readLines(String filename, Charset charset) throws IOException {
        return IOAdvice.readLines(new FileInputStream(filename), charset);
    }

    public static Stream<String> readLines(InputStream inputStream) {
        return IOAdvice.readLines(inputStream, StandardCharsets.UTF_8);
    }

    public static Stream<String> readLines(@NonNull InputStream inputStream, Charset charset) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        Scanner scanner = new Scanner(inputStream, charset);
        LinkedList<String> lines = new LinkedList<String>();
        while (scanner.hasNext()) {
            lines.add(scanner.nextLine());
        }
        scanner.close();
        return lines.stream();
    }

    public static Stream<String> readLinesFromClasspath(String filename, Charset charset) {
        return IOAdvice.readLines(IOAdvice.class.getResourceAsStream(filename), charset);
    }

    public static Stream<String> readLinesFromClasspath(String filename) {
        return IOAdvice.readLines(IOAdvice.class.getResourceAsStream(filename));
    }

    public static String readText(InputStream inputStream, Charset charset) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.readLines(inputStream, charset).forEach(line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static String readText(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.readLines(inputStream).forEach(line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static String readTextFromClasspath(String filename, Charset charset) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.forEachFromClasspath(filename, charset, line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static String readTextFromClasspath(String filename) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.forEachFromClasspath(filename, line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static void forEach(InputStream inputStream, Charset charset, Consumer<String> consumer) {
        IOAdvice.readLines(inputStream, charset).forEach(consumer);
    }

    public static void forEach(InputStream inputStream, Consumer<String> consumer) {
        IOAdvice.readLines(inputStream).forEach(consumer);
    }

    public static void forEachFromClasspath(String filename, Charset charset, Consumer<String> consumer) {
        IOAdvice.readLinesFromClasspath(filename, charset).forEach(consumer);
    }

    public static void forEachFromClasspath(String filename, Consumer<String> consumer) {
        IOAdvice.readLinesFromClasspath(filename).forEach(consumer);
    }

    public static void writeLines(List<String> lines, String filename, Charset charset) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), charset));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
    }

    public static void writeLines(List<String> lines, OutputStream outputStream, Charset charset) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
    }

    public static void transferText(InputStream inputStream, OutputStream outputStream, Charset charset, Function<String, String> function) throws IOException {
        Scanner scanner = new Scanner(inputStream, charset);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            while (scanner.hasNext()) {
                String line = function.apply(scanner.nextLine());
                writer.write(line);
                writer.newLine();
            }
        }
        scanner.close();
    }

    public static void printFile(String filename, Charset charset) throws IOException {
        IOAdvice.readLines(filename, charset).forEach(System.out::println);
    }

    public static void printInputStream(InputStream inputStream, Charset charset) {
        IOAdvice.readLines(inputStream, charset).forEach(System.out::println);
    }

    public static void printInputStream(InputStream inputStream) {
        IOAdvice.readLines(inputStream, StandardCharsets.UTF_8).forEach(System.out::println);
    }
}

