/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import develop.toolkit.base.components.EntitySign;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public abstract class EntityRegistry<T extends EntitySign<K>, K>
implements Serializable {
    private static final long serialVersionUID = 8580818076321536793L;
    protected Map<K, T> entityMap = new LinkedHashMap<K, T>();

    public EntityRegistry() {
        EntitySign[] defaultEntities = this.defaultEntity();
        if (defaultEntities != null) {
            for (EntitySign defaultEntity : defaultEntities) {
                this.entityMap.put(defaultEntity.key(), defaultEntity);
            }
        }
    }

    protected abstract T[] defaultEntity();

    public final void addCustomEntities(@NonNull T[] customEntities) {
        if (customEntities == null) {
            throw new NullPointerException("customEntities is marked non-null but is null");
        }
        if (customEntities != null) {
            for (T entity : customEntities) {
                this.entityMap.put(entity.key(), entity);
            }
        }
    }

    public final Optional<T> extract(K key) {
        if (this.entityMap.containsKey(key)) {
            return Optional.of((EntitySign)this.entityMap.get(key));
        }
        return Optional.empty();
    }

    public final T extractRequired(K key, RuntimeException customRuntimeException) {
        if (this.entityMap.containsKey(key)) {
            return (T)((EntitySign)this.entityMap.get(key));
        }
        throw customRuntimeException;
    }

    public final T extractOrDefault(K key, T defaultValue) {
        if (this.entityMap.containsKey(key)) {
            return (T)((EntitySign)this.entityMap.get(key));
        }
        return defaultValue;
    }
}

