/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import develop.toolkit.base.struct.http.HttpClientSender;
import java.net.http.HttpClient;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpClientHelper.class);
    private final HttpClient httpClient;
    private boolean onlyPrintFailed = true;

    public HttpClientHelper(Duration connectTimeout) {
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(connectTimeout).followRedirects(HttpClient.Redirect.NEVER).build();
    }

    public HttpClientHelper() {
        this(Duration.ofSeconds(5L));
    }

    public HttpClientSender get(String url) {
        return new HttpClientSender(this.httpClient, "GET", url).onlyPrintFailed(this.onlyPrintFailed);
    }

    public HttpClientSender post(String url) {
        return new HttpClientSender(this.httpClient, "POST", url).onlyPrintFailed(this.onlyPrintFailed);
    }

    public HttpClientSender put(String url) {
        return new HttpClientSender(this.httpClient, "PUT", url).onlyPrintFailed(this.onlyPrintFailed);
    }

    public HttpClientSender delete(String url) {
        return new HttpClientSender(this.httpClient, "DELETE", url).onlyPrintFailed(this.onlyPrintFailed);
    }

    public HttpClientSender request(String method, String url) {
        return new HttpClientSender(this.httpClient, method, url).onlyPrintFailed(this.onlyPrintFailed);
    }

    public HttpClientHelper(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setOnlyPrintFailed(boolean onlyPrintFailed) {
        this.onlyPrintFailed = onlyPrintFailed;
    }
}

