/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HttpAdviceResponse {
    private int httpStatus;
    private Map<String, List<String>> headers;
    private byte[] body;
    private long costTime;

    public String bodyOfString() {
        return new String(this.body, StandardCharsets.UTF_8);
    }

    public String getHeader(String header) {
        return StringUtils.join((Iterable)this.headers.getOrDefault(header, List.of()), (String)";");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nhttp response:\n    status: ").append(this.httpStatus).append("\n    headers:\n");
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            sb.append("        ").append(entry.getKey()).append(": ").append(StringUtils.join((Iterable)entry.getValue(), (String)";")).append("\n");
        }
        sb.append("    body: ").append(this.bodyOfString());
        return sb.toString();
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public long getCostTime() {
        return this.costTime;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setCostTime(long costTime) {
        this.costTime = costTime;
    }

    public HttpAdviceResponse() {
    }

    public HttpAdviceResponse(int httpStatus, Map<String, List<String>> headers, byte[] body, long costTime) {
        this.httpStatus = httpStatus;
        this.headers = headers;
        this.body = body;
        this.costTime = costTime;
    }
}

