/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct.http;

import develop.toolkit.base.struct.http.FormUrlencodedBody;
import develop.toolkit.base.struct.http.HttpClientReceiver;
import develop.toolkit.base.struct.http.MultiPartFormDataBody;
import develop.toolkit.base.struct.http.SenderHandler;
import develop.toolkit.base.struct.http.StringBodySenderHandler;
import develop.toolkit.base.utils.DateTimeAdvice;
import develop.toolkit.base.utils.StringAdvice;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientSender {
    private static final Logger log = LoggerFactory.getLogger(HttpClientSender.class);
    private final HttpClient httpClient;
    private final String method;
    private final String url;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private Duration readTimeout = Duration.ofSeconds(10L);
    private String debugLabel;
    private Object requestBody;
    private boolean onlyPrintFailed;

    public HttpClientSender(HttpClient httpClient, String method, String url) {
        this.httpClient = httpClient;
        this.method = method;
        this.url = url;
    }

    public HttpClientSender header(String header, String value) {
        this.headers.put(header, value);
        return this;
    }

    public HttpClientSender headers(Map<String, String> headers) {
        if (headers != null) {
            this.headers.putAll(headers);
        }
        return this;
    }

    public HttpClientSender headerAuthorization(String value) {
        this.headers.put("Authorization", value);
        return this;
    }

    public HttpClientSender headerContentType(String value) {
        this.headers.put("Content-Type", value);
        return this;
    }

    public HttpClientSender parameter(String parameter, Object value) {
        this.parameters.put(parameter, value);
        return this;
    }

    public HttpClientSender parameters(Map<String, Object> parameters) {
        if (parameters != null) {
            this.parameters.putAll(parameters);
        }
        return this;
    }

    public HttpClientSender readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpClientSender debugLabel(String debugLabel) {
        this.debugLabel = debugLabel;
        return this;
    }

    public HttpClientSender onlyPrintFailed(boolean onlyPrintFailed) {
        this.onlyPrintFailed = onlyPrintFailed;
        return this;
    }

    public HttpClientSender bodyJson(String json) {
        this.headers.put("Content-Type", "application/json;charset=utf-8");
        this.requestBody = json;
        return this;
    }

    public HttpClientSender bodyXml(String xml) {
        this.headers.put("Content-Type", "application/xml;charset=utf-8");
        this.requestBody = xml;
        return this;
    }

    public HttpClientSender bodyText(String text) {
        this.requestBody = text;
        return this;
    }

    public HttpClientSender bodyMultiPartFormData(MultiPartFormDataBody multiPartFormDataBody) {
        this.headers.put("Content-Type", "multipart/form-data; boundary=" + multiPartFormDataBody.getBoundary());
        this.requestBody = multiPartFormDataBody.buildBodyPublisher();
        return this;
    }

    public HttpClientSender bodyFormUrlencoded(FormUrlencodedBody formUrlencodedBody) {
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.requestBody = formUrlencodedBody.buildBody();
        return this;
    }

    public HttpClientSender bodyBytes(byte[] bytes) {
        this.requestBody = bytes;
        return this;
    }

    public void download(Path path, OpenOption ... openOptions) {
        this.send(HttpResponse.BodyHandlers::ofByteArray).ifSuccess(r -> r.save(path, openOptions));
    }

    public HttpClientReceiver<String> send() {
        return this.send(new StringBodySenderHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <BODY> HttpClientReceiver<BODY> send(SenderHandler<BODY> senderHandler) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().version(this.httpClient.version()).uri(URI.create(this.url + StringAdvice.urlParametersFormat(this.parameters, true)));
        this.headers.forEach(builder::header);
        HttpRequest request = builder.method(this.method, this.requestBody == null ? HttpRequest.BodyPublishers.noBody() : senderHandler.bodyPublisher(this.requestBody)).timeout(this.readTimeout).build();
        HttpClientReceiver<BODY> receiver = new HttpClientReceiver<BODY>();
        try {
            Instant start = Instant.now();
            HttpResponse<BODY> response = this.httpClient.send(request, senderHandler.bodyHandler());
            receiver.setCostTime(start.until(Instant.now(), ChronoUnit.MILLIS));
            receiver.setHttpStatus(response.statusCode());
            receiver.setHeaders(response.headers().map());
            receiver.setBody(response.body());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (HttpConnectTimeoutException e) {
            receiver.setConnectTimeout(true);
        }
        catch (HttpTimeoutException e) {
            receiver.setReadTimeout(true);
        }
        catch (IOException e) {
            receiver.setErrorMessage(e.getMessage());
        }
        finally {
            if (!(!log.isDebugEnabled() || this.onlyPrintFailed && receiver.isSuccess())) {
                this.printDebug(request, receiver);
            }
        }
        return receiver;
    }

    private String printBody(Object body) {
        if (body == null) {
            return "(No content)";
        }
        if (body instanceof String) {
            return (String)body;
        }
        if (body.getClass().isArray()) {
            return "(Bytes data)";
        }
        return "(Unknown data)";
    }

    private void printDebug(HttpRequest request, HttpClientReceiver<?> receiver) {
        StringBuilder sb = new StringBuilder("\n=========================================================================================================\n");
        sb.append("\nlabel: ").append(this.debugLabel == null ? "(Undefined)" : this.debugLabel).append("\nhttp request:\n  method: ").append(this.method).append("\n  url: ").append(request.uri().toString()).append("\n  headers:\n");
        request.headers().map().forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(StringUtils.join((Iterable)v, (String)";")).append("\n"));
        sb.append("  body: ").append(this.printBody(this.requestBody)).append("\n").append("\nhttp response:\n");
        if (receiver.isConnectTimeout()) {
            sb.append("  (connect timeout ").append(this.httpClient.connectTimeout().map(Duration::getSeconds).orElse(0L)).append("s)");
        } else if (receiver.isReadTimeout()) {
            sb.append("  (read timeout ").append(this.readTimeout.getSeconds()).append("s)");
        } else if (receiver.getErrorMessage() != null) {
            sb.append("  (ioerror ").append(receiver.getErrorMessage()).append(")");
        } else {
            sb.append("  status: ").append(receiver.getHttpStatus()).append("\n  headers:\n");
            for (Map.Entry<String, List<String>> entry : receiver.getHeaders().entrySet()) {
                sb.append("    ").append(entry.getKey()).append(": ").append(StringUtils.join((Iterable)entry.getValue(), (String)";")).append("\n");
            }
            sb.append("  cost: ").append(DateTimeAdvice.millisecondPretty(receiver.getCostTime())).append("\n");
            sb.append("  body: ").append(this.printBody(receiver.getBody()));
        }
        sb.append("\n\n=========================================================================================================\n");
        log.debug(sb.toString());
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public String getDebugLabel() {
        return this.debugLabel;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public boolean isOnlyPrintFailed() {
        return this.onlyPrintFailed;
    }
}

