/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct.range;

import develop.toolkit.base.utils.CompareAdvice;
import org.apache.commons.lang3.Validate;

public class Range<T extends Comparable<T>> {
    protected T start;
    protected T end;

    public Range(T start, T end) {
        Validate.isTrue((boolean)CompareAdvice.gte(end, start), (String)"Start value must be smaller or equal to end value.", (Object[])new Object[0]);
        this.start = start;
        this.end = end;
    }

    public T getStart() {
        return this.start;
    }

    public T getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$start = this.getStart();
        T other$start = other.getStart();
        if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
            return false;
        }
        T this$end = this.getEnd();
        T other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !this$end.equals(other$end));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Range;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        T $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : $end.hashCode());
        return result;
    }
}

