/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.components.Counter;
import develop.toolkit.base.struct.KeyValuePairs;
import develop.toolkit.base.struct.ListInMap;
import develop.toolkit.base.struct.TwoValues;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public final class ArrayAdvice {
    public static <E> boolean contains(E[] array, Object target, Function<E, ?> function) {
        if (array != null) {
            for (E item : array) {
                Object value = function.apply(item);
                if (target == null) {
                    return value == null;
                }
                if (!target.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> boolean contains(E[] array, Object target) {
        if (array != null) {
            for (E item : array) {
                if (target == null) {
                    return item == null;
                }
                if (!target.equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> Optional<E> getFirstMatch(E[] array, Object target, Function<E, ?> function) {
        if (array != null) {
            for (E item : array) {
                Object value = function.apply(item);
                if (!(target != null ? target.equals(value) : value == null)) continue;
                return Optional.ofNullable(item);
            }
        }
        return Optional.empty();
    }

    public static <E> Optional<E> getFirstMatch(E[] array, Object target) {
        if (array != null && target != null) {
            for (E item : array) {
                if (!target.equals(item)) continue;
                return Optional.of(item);
            }
        }
        return Optional.empty();
    }

    public static <E> Optional<E> getFirstTrue(E[] array, Predicate<E> predicate) {
        if (array != null) {
            for (E item : array) {
                if (!predicate.test(item)) continue;
                return Optional.ofNullable(item);
            }
        }
        return Optional.empty();
    }

    public static <E> Optional<E> getFirstFalse(E[] array, Predicate<E> predicate) {
        if (array != null) {
            for (E item : array) {
                if (predicate.test(item)) continue;
                return Optional.ofNullable(item);
            }
        }
        return Optional.empty();
    }

    public static <E> List<E> getAllMatch(E[] array, Object target, Function<E, ?> function) {
        if (array == null) {
            return null;
        }
        return Stream.of(array).filter(item -> {
            Object value;
            Object object = value = function == null ? item : function.apply(item);
            if (target == null) {
                return value == null;
            }
            return target.equals(value);
        }).collect(Collectors.toList());
    }

    public static <E> boolean allMatch(E[] array, Predicate<E> predicate) {
        if (predicate == null || array == null) {
            return false;
        }
        for (E e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean anyMatch(E[] array, Predicate<E> predicate) {
        if (array != null && predicate != null) {
            for (E e : array) {
                if (!predicate.test(e)) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> boolean allAccept(E[] array, Function<E, ?> function) {
        if (array == null || array.length == 0) {
            return false;
        }
        E targetValue = function == null ? array[0] : function.apply(array[0]);
        int size = array.length;
        for (int i = 1; i < size; ++i) {
            E itemValue;
            Object object = itemValue = function == null ? array[i] : function.apply(array[i]);
            if ((targetValue == null || targetValue.equals(itemValue)) && (targetValue != null || itemValue == null)) continue;
            return false;
        }
        return true;
    }

    public static <E, K, V> ListInMap<K, V> grouping(E[] array, Function<E, K> keySupplier, Function<E, V> valueSupplier) {
        ListInMap<K, V> map = new ListInMap<K, V>();
        for (E item : array) {
            map.putItem(keySupplier.apply(item), valueSupplier.apply(item));
        }
        return map;
    }

    public static <K, V> ListInMap<K, V> grouping(V[] array, Function<V, K> keySupplier) {
        ListInMap<K, V> map = new ListInMap<K, V>();
        for (V item : array) {
            map.putItem(keySupplier.apply(item), item);
        }
        return map;
    }

    public static <K, V> Map<K, V> groupingUniqueKey(V[] array, Function<V, K> keySupplier) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (V item : array) {
            map.put(keySupplier.apply(item), item);
        }
        return map;
    }

    public static <E, K> Counter<K> groupingCount(E[] array, Function<E, K> keySupplier) {
        Counter<K> counter = new Counter<K>();
        for (E item : array) {
            counter.add(keySupplier.apply(item));
        }
        return counter;
    }

    @SafeVarargs
    public static <E> Set<E> union(E[] ... arrays) {
        HashSet<E> set = new HashSet<E>();
        for (E[] array : arrays) {
            set.addAll(Arrays.asList(array));
        }
        return set;
    }

    @SafeVarargs
    public static <E> Set<E> intersection(E[] master, E[] ... other) {
        HashSet<E> set = new HashSet<E>();
        block0: for (E e : master) {
            for (E[] array : other) {
                if (!ArrayAdvice.contains(array, e)) continue block0;
            }
            set.add(e);
        }
        return set;
    }

    public static <E> Set<E> difference(E[] master, E[] other) {
        HashSet<E> set = new HashSet<E>();
        for (E e : master) {
            if (ArrayAdvice.contains(other, e)) continue;
            set.add(e);
        }
        return set;
    }

    @SafeVarargs
    public static <E> E[] merge(Class<E> clazz, E[] ... arrays) {
        Object[] mergeArray = (Object[])Array.newInstance(clazz, Stream.of(arrays).mapToInt(array -> ((Object[])array).length).sum());
        int i = 0;
        E[][] EArray = arrays;
        int n = EArray.length;
        for (int j = 0; j < n; ++j) {
            E[] array2;
            for (E item : array2 = EArray[j]) {
                if (item == null) continue;
                mergeArray[i++] = item;
            }
        }
        return mergeArray;
    }

    public static <E, T> ListInMap<E, T> associate(E[] master, T[] target, BiPredicate<E, T> predicate) {
        ListInMap<E, T> map = new ListInMap<E, T>();
        for (E e : master) {
            for (T t : target) {
                if (!predicate.test(e, t)) continue;
                map.putItem(e, t);
            }
        }
        return map;
    }

    public static <E, T> KeyValuePairs<E, T> associateOne(E[] master, T[] target, BiPredicate<E, T> predicate) {
        KeyValuePairs<E, Object> keyValuePairs = new KeyValuePairs<E, Object>();
        for (Object e : master) {
            Object matchT = ArrayAdvice.getFirstTrue(target, t -> predicate.test(e, t)).orElse(null);
            keyValuePairs.addKeyValue(e, matchT);
        }
        return keyValuePairs;
    }

    public static <E> TwoValues<List<E>, List<E>> partition(E[] collection, Predicate<E> predicate) {
        LinkedList<E> match = new LinkedList<E>();
        LinkedList<E> notMatch = new LinkedList<E>();
        for (E e : collection) {
            if (predicate.test(e)) {
                match.add(e);
                continue;
            }
            notMatch.add(e);
        }
        return TwoValues.of(match, notMatch);
    }

    public static <T, S> List<TwoValues<T, S>> zip(T[] master, S[] other) {
        if (master.length != other.length) {
            throw new IllegalArgumentException("list size must be same");
        }
        LinkedList<TwoValues<T, S>> list = new LinkedList<TwoValues<T, S>>();
        for (int i = 0; i < master.length; ++i) {
            list.add(TwoValues.of(master[i], other[i]));
        }
        return list;
    }

    public static <E> void pagingProcess(E[] array, int size, Consumer<E[]> consumer) {
        int total = array.length;
        int page = total % size == 0 ? total / size : total / size + 1;
        for (int i = 0; i < page; ++i) {
            int fromIndex = i * size;
            int toIndex = fromIndex + Math.min(total - fromIndex, size);
            Object[] subArray = ArrayUtils.subarray((Object[])array, (int)fromIndex, (int)toIndex);
            consumer.accept(subArray);
        }
    }

    public static <T, S> List<T> sort(T[] master, S[] sortTarget, BiPredicate<T, S> predicate) {
        return Stream.of(sortTarget).map(s -> ArrayAdvice.getFirstTrue(master, c -> predicate.test(c, s)).orElse(null)).collect(Collectors.toList());
    }

    public static <T, S> List<T> sort(T[] master, Collection<S> sortTarget, BiPredicate<T, S> predicate) {
        return sortTarget.stream().map(s -> ArrayAdvice.getFirstTrue(master, c -> predicate.test(c, s)).orElse(null)).collect(Collectors.toList());
    }
}

