/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.struct.ListInMap;
import develop.toolkit.base.utils.ArrayAdvice;
import develop.toolkit.base.utils.ObjectAdvice;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class IOAdvice {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(InputStream inputStream) {
        try (InputStream inputStream2 = inputStream;){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                inputStream.transferTo(baos);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toByteArrayFromClasspath(String filename) {
        return IOAdvice.toByteArray(IOAdvice.readInputStreamFromClasspath(filename));
    }

    public static Stream<String> readLines(String filename) {
        return IOAdvice.readLines(filename, null);
    }

    public static Stream<String> readLines(String filename, Charset charset) {
        try {
            return IOAdvice.readLines(new FileInputStream(filename), charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<String> readLines(InputStream inputStream) {
        return IOAdvice.readLines(inputStream, null);
    }

    public static Stream<String> readLines(InputStream inputStream, Charset charset) {
        Stream<String> stream;
        block9: {
            InputStream inputStream2 = inputStream;
            try {
                Scanner scanner = new Scanner(inputStream, charset == null ? StandardCharsets.UTF_8 : charset);
                LinkedList<String> lines = new LinkedList<String>();
                while (scanner.hasNext()) {
                    lines.add(scanner.nextLine());
                }
                scanner.close();
                stream = lines.stream();
                if (inputStream2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream2.close();
        }
        return stream;
    }

    public static InputStream readInputStreamFromClasspath(String filename) {
        return IOAdvice.class.getResourceAsStream((String)(filename.startsWith("/") ? filename : "/" + filename));
    }

    public static Stream<String> readLinesFromClasspath(String filename, Charset charset) {
        return IOAdvice.readLines(IOAdvice.readInputStreamFromClasspath(filename), charset);
    }

    public static Stream<String> readLinesFromClasspath(String filename) {
        return IOAdvice.readLines(IOAdvice.readInputStreamFromClasspath(filename), null);
    }

    public static Stream<String[]> splitFromClasspath(String filename, String regex) {
        return IOAdvice.readLinesFromClasspath(filename).map(line -> line.split(regex));
    }

    public static <T> Stream<T> splitFromClasspath(String filename, String regex, Class<T> clazz) {
        List list = IOAdvice.splitFromClasspath(filename, regex).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Stream.empty();
        }
        String[] first = (String[])list.get(0);
        Constructor constructor = ArrayAdvice.getFirstMatch(clazz.getConstructors(), first.length, Constructor::getParameterCount).orElseThrow(() -> new IllegalArgumentException("No match constructor for parameter size: " + first.length));
        Class[] parameterTypes = constructor.getParameterTypes();
        return list.stream().map(objs -> {
            try {
                Object[] parameters = new Object[((String[])objs).length];
                for (int i = 0; i < ((String[])objs).length; ++i) {
                    parameters[i] = ObjectAdvice.primitiveTypeCast(objs[i], parameterTypes[i]);
                }
                return constructor.newInstance(parameters);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <K> ListInMap<K, String[]> splitGroupingFormClasspath(String filename, String regex, Function<String[], K> keyFunction) {
        ListInMap map = new ListInMap();
        IOAdvice.splitFromClasspath(filename, regex).forEach(objs -> map.putItem(keyFunction.apply((String[])objs), objs));
        return map;
    }

    public static <K> Map<K, String[]> splitGroupingUniqueFormClasspath(String filename, String regex, Function<String[], K> keyFunction) {
        HashMap map = new HashMap();
        IOAdvice.splitFromClasspath(filename, regex).forEach(objs -> {
            Object k = keyFunction.apply((String[])objs);
            if (map.containsKey(k)) {
                throw new IllegalStateException("exists key \"" + k + "\"");
            }
            map.put(k, objs);
        });
        return map;
    }

    public static <K, T> ListInMap<K, T> splitGroupingFormClasspath(String filename, String regex, Class<T> clazz, Function<T, K> keyFunction) {
        ListInMap map = new ListInMap();
        IOAdvice.splitFromClasspath(filename, regex, clazz).forEach(t -> map.putItem(keyFunction.apply(t), t));
        return map;
    }

    public static <K, V> ListInMap<K, V> splitGroupingFormClasspath(String filename, String regex, Function<String[], K> keyFunction, Function<String[], V> valueFunction) {
        ListInMap map = new ListInMap();
        IOAdvice.splitFromClasspath(filename, regex).forEach(objs -> map.putItem(keyFunction.apply((String[])objs), valueFunction.apply((String[])objs)));
        return map;
    }

    public static <K, V, T> ListInMap<K, V> splitGroupingFormClasspath(String filename, String regex, Class<T> clazz, Function<T, K> keyFunction, Function<T, V> valueFunction) {
        ListInMap map = new ListInMap();
        IOAdvice.splitFromClasspath(filename, regex, clazz).forEach(t -> map.putItem(keyFunction.apply(t), valueFunction.apply(t)));
        return map;
    }

    public static <K, V> Map<K, V> splitGroupingUniqueFormClasspath(String filename, String regex, Function<String[], K> keyFunction, Function<String[], V> valueFunction) {
        HashMap map = new HashMap();
        IOAdvice.splitFromClasspath(filename, regex).forEach(objs -> {
            Object k = keyFunction.apply((String[])objs);
            if (map.containsKey(k)) {
                throw new IllegalStateException("exists key \"" + k + "\"");
            }
            map.put(k, valueFunction.apply((String[])objs));
        });
        return map;
    }

    public static String readText(InputStream inputStream, Charset charset) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.readLines(inputStream, charset).forEach(line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static String readText(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.readLines(inputStream).forEach(line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static String readTextFromClasspath(String filename, Charset charset) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.readLinesFromClasspath(filename, charset).forEach(line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static String readTextFromClasspath(String filename) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.readLinesFromClasspath(filename).forEach(line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static void writeLines(List<String> lines, String filename, Charset charset) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), charset));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLines(List<String> lines, String filename) {
        IOAdvice.writeLines(lines, filename, StandardCharsets.UTF_8);
    }

    public static void writeLines(List<String> lines, OutputStream outputStream, Charset charset) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendLines(List<String> lines, String filename, Charset charset) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, true), charset));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendLines(List<String> lines, String filename) {
        IOAdvice.appendLines(lines, filename, StandardCharsets.UTF_8);
    }

    public static void copyText(InputStream inputStream, OutputStream outputStream, Charset charset, Function<String, String> function) {
        Scanner scanner = new Scanner(inputStream, charset);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            while (scanner.hasNext()) {
                String line = function.apply(scanner.nextLine());
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        scanner.close();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static long copyQuietly(File source, File target) {
        if (target.getParentFile().mkdirs()) {
            try (FileInputStream inputStream = new FileInputStream(source);){
                long l;
                try (FileOutputStream outputStream = new FileOutputStream(target);){
                    l = ((InputStream)inputStream).transferTo(outputStream);
                }
                return l;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return -1L;
    }

    public static void printFile(String filename, Charset charset) {
        IOAdvice.readLines(filename, charset).forEach(System.out::println);
    }

    public static void printInputStream(InputStream inputStream, Charset charset) {
        IOAdvice.readLines(inputStream, charset).forEach(System.out::println);
    }

    public static void printInputStream(InputStream inputStream) {
        IOAdvice.readLines(inputStream, StandardCharsets.UTF_8).forEach(System.out::println);
    }
}

