/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.EmptyExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.MethodExpression;
import com.github.developframework.expression.ObjectExpression;
import develop.toolkit.base.constants.DateFormatConstants;
import develop.toolkit.base.struct.KeyValuePair;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.List;

public final class JacksonAdvice {
    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateFormatConstants.STANDARD_FORMATTER));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateFormatConstants.STANDARD_FORMATTER));
        objectMapper.registerModule((Module)javaTimeModule);
        return objectMapper;
    }

    public static String serializeQuietly(ObjectMapper objectMapper, Object object, boolean pretty) {
        if (pretty) {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        return objectMapper.writeValueAsString(object);
    }

    public static <T> T deserializeValue(ObjectMapper objectMapper, JsonNode rootNode, String expressionValue, Class<T> clazz) {
        return (T)objectMapper.treeToValue((TreeNode)JacksonAdvice.parseExpressionToJsonNode(rootNode, Expression.parse((String)expressionValue)), clazz);
    }

    public static <T> T[] deserializeArray(ObjectMapper objectMapper, JsonNode rootNode, String expressionValue, Class<T> clazz) {
        JsonNode jsonNode = JacksonAdvice.parseExpressionToJsonNode(rootNode, Expression.parse((String)expressionValue));
        if (!jsonNode.isArray()) {
            throw new IllegalArgumentException("\"" + expressionValue + "\" value is not a array.");
        }
        return (Object[])objectMapper.readValue(jsonNode.toString(), (JavaType)objectMapper.getTypeFactory().constructArrayType(clazz));
    }

    public static <T> List<T> deserializeList(ObjectMapper objectMapper, JsonNode rootNode, String expressionValue, Class<T> clazz) {
        JsonNode jsonNode = JacksonAdvice.parseExpressionToJsonNode(rootNode, Expression.parse((String)expressionValue));
        if (!jsonNode.isArray()) {
            throw new IllegalArgumentException("\"" + expressionValue + "\" value is not a list.");
        }
        return (List)objectMapper.readValue(jsonNode.toString(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, clazz));
    }

    @SafeVarargs
    public static Object[] deserializeValues(ObjectMapper objectMapper, JsonNode rootNode, KeyValuePair<String, Class<?>> ... expressionValues) {
        Object[] values = new Object[expressionValues.length];
        for (int i = 0; i < expressionValues.length; ++i) {
            KeyValuePair<String, Class<?>> kv = expressionValues[i];
            Expression expression = Expression.parse((String)kv.getKey());
            JsonNode jsonNode = JacksonAdvice.parseExpressionToJsonNode(rootNode, expression);
            values[i] = objectMapper.treeToValue((TreeNode)jsonNode, kv.getValue());
        }
        return values;
    }

    private static JsonNode parseExpressionToJsonNode(JsonNode jsonNode, Expression expression) {
        if (expression != EmptyExpression.INSTANCE) {
            for (Expression singleExpression : expression.expressionTree()) {
                if (singleExpression instanceof ObjectExpression) {
                    jsonNode = JacksonAdvice.existsJsonNode(jsonNode, ((ObjectExpression)singleExpression).getPropertyName());
                    continue;
                }
                if (singleExpression instanceof ArrayExpression) {
                    ArrayExpression ae = (ArrayExpression)singleExpression;
                    if (!(jsonNode = JacksonAdvice.existsJsonNode(jsonNode, ae.getPropertyName())).isArray()) continue;
                    jsonNode = jsonNode.get(ae.getIndex());
                    continue;
                }
                if (!(singleExpression instanceof MethodExpression)) continue;
                throw new IllegalArgumentException("not support method expression.");
            }
        }
        return jsonNode;
    }

    private static JsonNode existsJsonNode(JsonNode parentNode, String propertyName) {
        JsonNode node = parentNode.get(propertyName);
        if (node == null) {
            throw new IllegalArgumentException("Not found node \"" + propertyName + "\"");
        }
        return node;
    }
}

