/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.struct.range.IntRange;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.Validate;

public final class RandomAdvice {
    public static int[] nextInts(int startInclusive, int endExclusive, int count) {
        Validate.isTrue((endExclusive - startInclusive >= count ? 1 : 0) != 0, (String)"Difference value must be greater or equal to end value.", (Object[])new Object[0]);
        ArrayList<Integer> list = new ArrayList<Integer>(List.of(new IntRange(startInclusive, endExclusive).generate()));
        int[] result = new int[count];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)list.remove(RandomUtils.nextInt((int)0, (int)list.size()));
        }
        return result;
    }

    public static <T> List<T> nextElements(List<T> list, int count) {
        return IntStream.of(RandomAdvice.nextInts(0, list.size(), count)).mapToObj(list::get).collect(Collectors.toList());
    }

    public static <T> T nextElement(List<T> list) {
        return list.get(list.size() == 1 ? 0 : RandomUtils.nextInt((int)0, (int)list.size()));
    }
}

