/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

public abstract class SortAdvice {
    public static <T extends Comparable<T>> void quickSort(T[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        SortAdvice.quickSortRecursive(array, (int)0, (int)(array.length - 1));
    }

    private static <T extends Comparable<T>> void quickSortRecursive(T[] array, int start, int end) {
        if (start >= end) {
            return;
        }
        int l = start;
        int r = end;
        T standard = array[start];
        while (l != r) {
            while (l < end && array[l].compareTo(standard) < 0) {
                ++l;
            }
            while (start < r && array[r].compareTo(standard) > 0) {
                --r;
            }
            T t = array[l];
            array[l] = array[r];
            array[r] = t;
        }
        SortAdvice.quickSortRecursive(array, (int)0, (int)(l - 1));
        SortAdvice.quickSortRecursive(array, (int)(l + 1), (int)end);
    }

    public static <T extends Comparable<T>> void selectSort(T[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            int minIndex = i;
            for (int j = i + 1; j < array.length; ++j) {
                if (array[j].compareTo(array[minIndex]) >= 0) continue;
                minIndex = j;
            }
            if (i == minIndex) continue;
            T t = array[i];
            array[i] = array[minIndex];
            array[minIndex] = t;
        }
    }
}

